/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.access;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public class AccessGeoSPARQL {
    public static boolean isPredicateOfFeature(Node n) {
        return n.equals(Geo.HAS_GEOMETRY_NODE) || n.equals(Geo.HAS_DEFAULT_GEOMETRY_NODE);
    }

    public static boolean isPredicateOfGeoResource(Node n) {
        return n.equals(Geo.AS_WKT_NODE) || n.equals(Geo.AS_GML_NODE) || n.equals(Geo.HAS_SERIALIZATION_NODE);
    }

    public static boolean isTripleOfFeature(Triple t) {
        return AccessGeoSPARQL.isPredicateOfFeature(t.getPredicate());
    }

    public static boolean isTripleOfGeoResource(Triple t) {
        return AccessGeoSPARQL.isPredicateOfGeoResource(t.getPredicate());
    }

    public static boolean containsGeoLiterals(Graph graph) {
        return AccessGeoSPARQL.containsGeoLiterals(graph, null);
    }

    public static boolean hasGeoLiterals(Graph graph, Node geometry) {
        Objects.requireNonNull(geometry);
        return AccessGeoSPARQL.containsGeoLiterals(graph, geometry);
    }

    public static boolean hasGeoResources(Graph graph, Node feature) {
        Objects.requireNonNull(feature);
        boolean result = graph.contains(feature, Geo.HAS_DEFAULT_GEOMETRY_NODE, null) || graph.contains(feature, Geo.HAS_GEOMETRY_NODE, null);
        return result;
    }

    public static boolean isSpatialObjectByProperties(Graph graph, Node featureOrGeometry) {
        return AccessGeoSPARQL.hasGeoLiterals(graph, featureOrGeometry) || AccessGeoSPARQL.hasGeoResources(graph, featureOrGeometry);
    }

    public static ExtendedIterator<Triple> findSpecificGeoResources(AtomicBoolean cancel, Graph graph) {
        ExtendedIterator<Triple> result = G.find(cancel, graph, null, Geo.HAS_DEFAULT_GEOMETRY_NODE, null);
        try {
            boolean hasDefaultGeometry = result.hasNext();
            ExtendedIterator<Triple> it = G.find(cancel, graph, null, Geo.HAS_GEOMETRY_NODE, null);
            result = hasDefaultGeometry ? result.andThen(it.filterDrop(t -> G.hasProperty(graph, t.getSubject(), Geo.HAS_DEFAULT_GEOMETRY_NODE))) : result.andThen(it);
        }
        catch (RuntimeException e2) {
            result.close();
            throw AccessGeoSPARQL.buildException(e2);
        }
        return result;
    }

    public static ExtendedIterator<Triple> findDefaultGeoResources(AtomicBoolean cancel, Graph graph) {
        return G.find(cancel, graph, null, Geo.HAS_DEFAULT_GEOMETRY_NODE, null);
    }

    public static ExtendedIterator<Triple> findSpecificGeoResources(AtomicBoolean cancel, Graph graph, Node feature) {
        Objects.requireNonNull(feature);
        ExtendedIterator<Triple> result = G.find(cancel, graph, feature, Geo.HAS_DEFAULT_GEOMETRY_NODE, null);
        try {
            if (!result.hasNext()) {
                result.close();
            }
            result = G.find(cancel, graph, feature, Geo.HAS_GEOMETRY_NODE, null);
        }
        catch (RuntimeException e2) {
            result.close();
            throw AccessGeoSPARQL.buildException(e2);
        }
        return result;
    }

    public static Iterator<Triple> findSpecificGeoLiteralsByFeature(AtomicBoolean cancel, Graph graph, Node feature) {
        return Iter.flatMap(AccessGeoSPARQL.findSpecificGeoResources(cancel, graph, feature), t -> AccessGeoSPARQL.findSpecificGeoLiterals(cancel, graph, t.getObject()));
    }

    public static ExtendedIterator<Triple> findSpecificGeoLiterals(AtomicBoolean cancel, Graph graph) {
        ExtendedIterator<Triple> result = G.find(cancel, graph, null, Geo.AS_WKT_NODE, null);
        try {
            result = result.andThen(G.find(cancel, graph, null, Geo.AS_GML_NODE, null));
            if (!result.hasNext()) {
                result.close();
                result = G.find(cancel, graph, null, Geo.HAS_SERIALIZATION_NODE, null);
            } else {
                ExtendedIterator<Triple> it = G.find(cancel, graph, null, Geo.HAS_SERIALIZATION_NODE, null).filterDrop(t -> G.hasProperty(graph, t.getSubject(), Geo.AS_WKT_NODE) || G.hasProperty(graph, t.getSubject(), Geo.AS_GML_NODE));
                result = result.andThen(it);
            }
        }
        catch (RuntimeException e2) {
            result.close();
            throw AccessGeoSPARQL.buildException(e2);
        }
        return result;
    }

    public static ExtendedIterator<Triple> findSpecificGeoLiterals(AtomicBoolean cancel, Graph graph, Node geometry) {
        Objects.requireNonNull(geometry);
        ExtendedIterator<Triple> result = G.find(cancel, graph, geometry, Geo.AS_WKT_NODE, null);
        try {
            result = result.andThen(G.find(cancel, graph, geometry, Geo.AS_GML_NODE, null));
            if (!result.hasNext()) {
                result.close();
                result = G.find(cancel, graph, geometry, Geo.HAS_SERIALIZATION_NODE, null);
            }
        }
        catch (RuntimeException e2) {
            result.close();
            throw AccessGeoSPARQL.buildException(e2);
        }
        return result;
    }

    public static Node getGeoLiteral(Graph graph, Node geometry) {
        Triple t = AccessGeoSPARQL.getGeoLiteralTriple(graph, geometry);
        Node n = t == null ? null : t.getObject();
        return n;
    }

    public static Triple getGeoLiteralTriple(Graph graph, Node geometry) {
        Objects.requireNonNull(geometry);
        Triple t = AccessGeoSPARQL.getTripleSP(graph, geometry, Geo.HAS_SERIALIZATION_NODE);
        if (t != null) {
            return t;
        }
        t = AccessGeoSPARQL.getTripleSP(graph, geometry, Geo.AS_WKT_NODE);
        if (t != null) {
            return t;
        }
        t = AccessGeoSPARQL.getTripleSP(graph, geometry, Geo.AS_GML_NODE);
        if (t != null) {
            return t;
        }
        return null;
    }

    private static Triple getTripleSP(Graph graph, Node s, Node p) {
        Node o = G.getSP(graph, s, p);
        Triple t = o == null ? null : Triple.create(s, p, o);
        return t;
    }

    private static boolean containsGeoLiterals(Graph graph, Node node) {
        boolean result = graph.contains(node, Geo.HAS_SERIALIZATION_NODE, null) || graph.contains(node, Geo.AS_WKT_NODE, null) || graph.contains(node, Geo.AS_GML_NODE, null);
        return result;
    }

    public static RuntimeException buildException(RuntimeException e2) {
        if (e2 instanceof QueryCancelledException) {
            QueryCancelledException e22 = (QueryCancelledException)e2;
            return new QueryCancelledException(e22);
        }
        return new RuntimeException(e2);
    }
}

