/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.match;

import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple3;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.rdfs.engine.Match;
import org.apache.jena.tdb2.match.MapperXTDB;
import org.apache.jena.tdb2.store.GraphTDB;
import org.apache.jena.tdb2.store.GraphViewSwitchable;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;

public class MatchTDB
implements Match<NodeId, Tuple3<NodeId>> {
    private GraphTDB graph;
    private MapperX<NodeId, Tuple3<NodeId>> mapper;

    protected MatchTDB(GraphTDB graph, MapperX<NodeId, Tuple3<NodeId>> mapper) {
        this.graph = graph;
        this.mapper = mapper;
    }

    public static MatchTDB wrap(Graph g) {
        if (g instanceof GraphViewSwitchable) {
            GraphViewSwitchable gvs = (GraphViewSwitchable)g;
            g = gvs.getBaseGraph();
        }
        if (!(g instanceof GraphTDB)) {
            throw new IllegalArgumentException("Not a TDB2 graph");
        }
        GraphTDB tdbGraph = (GraphTDB)g;
        NodeTable nodeTable = tdbGraph.getNodeTupleTable().getNodeTable();
        MapperXTDB mapper = new MapperXTDB(nodeTable);
        return new MatchTDB(tdbGraph, mapper);
    }

    @Override
    public Stream<Tuple3<NodeId>> match(NodeId s, NodeId p, NodeId o) {
        return Iter.asStream(this.graph.getNodeTupleTable().find(s, p, o)).filter(t -> {
            boolean b = NodeId.isDoesNotExist((NodeId)t.get(0)) || NodeId.isDoesNotExist((NodeId)t.get(1)) || NodeId.isDoesNotExist((NodeId)t.get(2));
            return !b;
        }).map(t -> TupleFactory.create3((NodeId)t.get(0), (NodeId)t.get(1), (NodeId)t.get(2)));
    }

    @Override
    public MapperX<NodeId, Tuple3<NodeId>> getMapper() {
        return this.mapper;
    }
}

