/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.facetset;

import org.apache.lucene.util.NumericUtils;

public record DimRange(long min, long max) {
    public static DimRange fromLongs(long min2, boolean minInclusive, long max2, boolean maxInclusive) {
        if (!minInclusive) {
            if (min2 != Long.MAX_VALUE) {
                ++min2;
            } else {
                throw new IllegalArgumentException("Invalid min input: " + min2);
            }
        }
        if (!maxInclusive) {
            if (max2 != Long.MIN_VALUE) {
                --max2;
            } else {
                throw new IllegalArgumentException("Invalid max input: " + max2);
            }
        }
        if (min2 > max2) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum, max=" + max2 + ", min=" + min2);
        }
        return new DimRange(min2, max2);
    }

    public static DimRange fromDoubles(double min2, boolean minInclusive, double max2, boolean maxInclusive) {
        if (Double.isNaN(min2)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min2 = Math.nextUp(min2);
        }
        if (Double.isNaN(max2)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max2 = Math.nextDown(max2);
        }
        if (min2 > max2) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
        return new DimRange(NumericUtils.doubleToSortableLong(min2), NumericUtils.doubleToSortableLong(max2));
    }

    public static DimRange fromFloats(float min2, boolean minInclusive, float max2, boolean maxInclusive) {
        if (Float.isNaN(min2)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min2 = Math.nextUp(min2);
        }
        if (Float.isNaN(max2)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max2 = Math.nextDown(max2);
        }
        if (min2 > max2) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
        return new DimRange(NumericUtils.floatToSortableInt(min2), NumericUtils.floatToSortableInt(max2));
    }
}

