/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;

public abstract class FunctionValues {
    public byte byteVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public short shortVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public float floatVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int intVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long longVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double doubleVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String strVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean boolVal(int doc) throws IOException {
        return this.intVal(doc) != 0;
    }

    public float[] floatVectorVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] byteVectorVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean bytesVal(int doc, BytesRefBuilder target) throws IOException {
        String s = this.strVal(doc);
        if (s == null) {
            target.clear();
            return false;
        }
        target.copyChars(s);
        return true;
    }

    public Object objectVal(int doc) throws IOException {
        return Float.valueOf(this.floatVal(doc));
    }

    public boolean exists(int doc) throws IOException {
        return true;
    }

    public int ordVal(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int numOrd() {
        throw new UnsupportedOperationException();
    }

    public float cost() {
        return 100.0f;
    }

    public abstract String toString(int var1) throws IOException;

    public ValueFiller getValueFiller() {
        return new ValueFiller(){
            private final MutableValueFloat mval = new MutableValueFloat();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) throws IOException {
                this.mval.value = FunctionValues.this.floatVal(doc);
            }
        };
    }

    public void byteVal(int doc, byte[] vals) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void shortVal(int doc, short[] vals) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void floatVal(int doc, float[] vals) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void intVal(int doc, int[] vals) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void longVal(int doc, long[] vals) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void doubleVal(int doc, double[] vals) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void strVal(int doc, String[] vals) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Explanation explain(int doc) throws IOException {
        return Explanation.match((Number)Float.valueOf(this.floatVal(doc)), this.toString(doc), new Explanation[0]);
    }

    public ValueSourceScorer getScorer(LeafReaderContext readerContext) {
        return new ValueSourceScorer(this, readerContext, this){

            @Override
            public boolean matches(int doc) {
                return true;
            }

            @Override
            public float matchCost() {
                return 0.0f;
            }
        };
    }

    public ValueSourceScorer getRangeScorer(LeafReaderContext readerContext, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) throws IOException {
        float lower = lowerVal == null ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerVal);
        float upper = upperVal == null ? Float.POSITIVE_INFINITY : Float.parseFloat(upperVal);
        final float l = lower;
        final float u = upper;
        if (includeLower && includeUpper) {
            return new ValueSourceScorer(readerContext, this){

                @Override
                public boolean matches(int doc) throws IOException {
                    if (!FunctionValues.this.exists(doc)) {
                        return false;
                    }
                    float docVal = FunctionValues.this.floatVal(doc);
                    return docVal >= l && docVal <= u;
                }
            };
        }
        if (includeLower && !includeUpper) {
            return new ValueSourceScorer(readerContext, this){

                @Override
                public boolean matches(int doc) throws IOException {
                    if (!FunctionValues.this.exists(doc)) {
                        return false;
                    }
                    float docVal = FunctionValues.this.floatVal(doc);
                    return docVal >= l && docVal < u;
                }
            };
        }
        if (!includeLower && includeUpper) {
            return new ValueSourceScorer(readerContext, this){

                @Override
                public boolean matches(int doc) throws IOException {
                    if (!FunctionValues.this.exists(doc)) {
                        return false;
                    }
                    float docVal = FunctionValues.this.floatVal(doc);
                    return docVal > l && docVal <= u;
                }
            };
        }
        return new ValueSourceScorer(readerContext, this){

            @Override
            public boolean matches(int doc) throws IOException {
                if (!FunctionValues.this.exists(doc)) {
                    return false;
                }
                float docVal = FunctionValues.this.floatVal(doc);
                return docVal > l && docVal < u;
            }
        };
    }

    public static abstract class ValueFiller {
        public abstract MutableValue getValue();

        public abstract void fillValue(int var1) throws IOException;
    }
}

