/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import java.util.Objects;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.main.sys.JettyLib;
import org.eclipse.jetty.ee11.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee11.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Password;

public class JettySecurityLib {
    public static final AuthScheme dftAuthMode;
    public static AuthScheme authMode;
    private static String ANY_USER;

    public static SecurityHandler makeSecurityHandlerForPathspec(String pathSpec, String realm, UserStore userStore) {
        ConstraintSecurityHandler sh = JettySecurityLib.makeSecurityHandler(realm, userStore);
        JettySecurityLib.addPathConstraint(sh, pathSpec);
        return sh;
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore) {
        return JettySecurityLib.makeSecurityHandler(realm, userStore, authMode);
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore, AuthScheme authMode) {
        return JettySecurityLib.makeSecurityHandler$(realm, userStore, authMode);
    }

    public static ConstraintSecurityHandler makeSecurityHandler$(String realm, UserStore userStore, AuthScheme authMode) {
        Objects.requireNonNull(userStore);
        if (authMode == null) {
            authMode = dftAuthMode;
        }
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        DefaultIdentityService identService = new DefaultIdentityService();
        securityHandler.setIdentityService(identService);
        HashLoginService loginService = new HashLoginService(realm);
        loginService.setUserStore(userStore);
        loginService.setIdentityService(identService);
        securityHandler.setLoginService(loginService);
        LoginAuthenticator authenticator = authMode == AuthScheme.BASIC ? new BasicAuthenticator() : new DigestAuthenticator();
        securityHandler.setAuthenticator(authenticator);
        if (realm != null) {
            securityHandler.setRealmName(realm);
        }
        return securityHandler;
    }

    public static void addPathConstraint(ConstraintSecurityHandler securityHandler, String pathSpec) {
        JettySecurityLib.addPathConstraint(securityHandler, pathSpec, null);
    }

    private static void addPathConstraint(ConstraintSecurityHandler securityHandler, String pathSpec, String role) {
        Objects.requireNonNull(securityHandler);
        Objects.requireNonNull(pathSpec);
        ConstraintMapping mapping = new ConstraintMapping();
        Constraint.Builder constraintBuilder = new Constraint.Builder();
        if (role != null) {
            constraintBuilder.roles(role);
            constraintBuilder.authorization(Constraint.Authorization.SPECIFIC_ROLE);
        } else {
            constraintBuilder.authorization(Constraint.Authorization.ANY_USER);
        }
        String authName = securityHandler.getAuthenticator().getAuthenticationType();
        constraintBuilder.name(authName);
        Constraint constraint = constraintBuilder.build();
        mapping.setConstraint(constraint);
        mapping.setPathSpec(pathSpec);
        securityHandler.addConstraintMapping(mapping);
    }

    public static UserStore makeUserStore(String passwordFile) {
        if (!FileOps.exists(passwordFile)) {
            throw new FusekiConfigException("No such file: " + passwordFile);
        }
        PropertyUserStore propertyUserStore = new PropertyUserStore();
        Resource pwResource = JettyLib.newResource(passwordFile);
        propertyUserStore.setConfig(pwResource);
        propertyUserStore.setReloadInterval(5);
        try {
            propertyUserStore.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("UserStore", ex);
        }
        return propertyUserStore;
    }

    public static UserStore makeUserStore(String user, String password) {
        return JettySecurityLib.makeUserStore(user, password, ANY_USER);
    }

    private static UserStore makeUserStore(String user, String password, String role) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        UserStore userStore = new UserStore();
        JettySecurityLib.addUser(userStore, user, password, role);
        try {
            userStore.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("UserStore", ex);
        }
        return userStore;
    }

    public static UserStore addUser(UserStore userStore, String user, String password) {
        return JettySecurityLib.addUser(userStore, user, password, ANY_USER);
    }

    public static UserStore addUser(UserStore userStore, String user, String password, String role) {
        String[] stringArray;
        if (role == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = role;
        }
        String[] roles = stringArray;
        Password cred = new Password(password);
        userStore.addUser(user, cred, roles);
        return userStore;
    }

    static {
        authMode = dftAuthMode = AuthScheme.BASIC;
        ANY_USER = null;
    }
}

