/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSPARQLService
extends GraphBase
implements Graph {
    private static Logger log = LoggerFactory.getLogger(GraphSPARQLService.class);
    private String serviceURI;
    private String graphIRI = null;

    public GraphSPARQLService(String serviceURI) {
        this.serviceURI = serviceURI;
        this.graphIRI = null;
    }

    public GraphSPARQLService(String serviceURI, String graphIRI) {
        this.serviceURI = serviceURI;
        this.graphIRI = graphIRI;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        Node s = m.getSubject();
        Var sVar = null;
        if (s == null) {
            sVar = Var.alloc("s");
            s = sVar;
        }
        Node p = m.getPredicate();
        Var pVar = null;
        if (p == null) {
            pVar = Var.alloc("p");
            p = pVar;
        }
        Node o = m.getObject();
        Var oVar = null;
        if (o == null) {
            oVar = Var.alloc("o");
            o = oVar;
        }
        Triple triple = Triple.create(s, p, o);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        OpBGP op = new OpBGP(pattern);
        return null;
    }
}

