/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.mock2.MockHttpConnection;
import org.apache.juneau.rest.mock2.MockServletRequest;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;

public class MockRest
implements MockHttpConnection {
    private static Map<Class<?>, RestContext> CONTEXTS_DEBUG = new ConcurrentHashMap();
    private static Map<Class<?>, RestContext> CONTEXTS_NORMAL = new ConcurrentHashMap();
    private final RestContext ctx;
    protected final Map<String, Object> headers;
    protected final boolean debug;
    final String contextPath;
    final String servletPath;

    protected MockRest(Builder b) {
        try {
            Map<Class<?>, RestContext> contexts;
            this.debug = b.debug;
            Class<?> c = b.impl instanceof Class ? (Class<?>)b.impl : b.impl.getClass();
            Map<Class<?>, RestContext> map = contexts = this.debug ? CONTEXTS_DEBUG : CONTEXTS_NORMAL;
            if (!contexts.containsKey(c)) {
                Object o = b.impl instanceof Class ? ((Class)b.impl).newInstance() : b.impl;
                RestContextBuilder rcb = RestContext.create((Object)o);
                if (this.debug) {
                    rcb.debug(Enablement.TRUE);
                    rcb.callLoggerConfig(RestCallLoggerConfig.DEFAULT_DEBUG);
                }
                RestContext rc = rcb.build();
                if (o instanceof RestServlet) {
                    ((RestServlet)o).setContext(rc);
                } else {
                    rc.postInit();
                }
                rc.postInitChildFirst();
                contexts.put(c, rc);
            }
            this.ctx = contexts.get(c);
            this.headers = new LinkedHashMap<String, Object>(b.headers);
            this.contextPath = b.contextPath;
            this.servletPath = b.servletPath;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder create(Object impl) {
        return new Builder(impl);
    }

    public static MockRest build(Object impl) {
        return MockRest.build(impl, (Marshall)SimpleJson.DEFAULT);
    }

    public static MockRest build(Object impl, Marshall m) {
        return MockRest.create(impl).marshall(m).build();
    }

    public static MockRest build(Object impl, Serializer s, Parser p) {
        return MockRest.create(impl).serializer(s).parser(p).build();
    }

    @Override
    public MockServletRequest request(String method, String path, Map<String, Object> headers, Object body) {
        String p = RestUtils.trimContextPath((String)this.ctx.getPath(), (String)path);
        return MockServletRequest.create(method, p, new Object[0]).contextPath(StringUtils.emptyIfNull((String)this.contextPath)).servletPath(StringUtils.emptyIfNull((String)this.servletPath)).body(body).headers(this.headers).headers(headers).debug(this.debug).restContext(this.ctx);
    }

    public MockServletRequest request(String method, String path) {
        return this.request(method, path, (Map)null, (Object)null);
    }

    public MockServletRequest request(String method, String path, Object body) {
        return this.request(method, path, (Map)null, body);
    }

    public MockServletRequest request(String method, Map<String, Object> headers, String path) {
        return this.request(method, path, (Map)headers, (Object)null);
    }

    public MockServletRequest get(String path) {
        return this.request("GET", path, (Map)null, (Object)null);
    }

    public MockServletRequest get() {
        return this.get("");
    }

    public MockServletRequest put(String path, Object body) {
        return this.request("PUT", path, (Map)null, body);
    }

    public MockServletRequest post(String path, Object body) {
        return this.request("POST", path, (Map)null, body);
    }

    public MockServletRequest delete(String path) {
        return this.request("DELETE", path, (Map)null, (Object)null);
    }

    public MockServletRequest head(String path) {
        return this.request("HEAD", path, (Map)null, (Object)null);
    }

    public MockServletRequest options(String path) {
        return this.request("OPTIONS", path, (Map)null, (Object)null);
    }

    public MockServletRequest patch(String path, Object body) {
        return this.request("PATCH", path, (Map)null, body);
    }

    public MockServletRequest connect(String path) {
        return this.request("CONNECT", path, (Map)null, (Object)null);
    }

    public MockServletRequest trace(String path) {
        return this.request("TRACE", path, (Map)null, (Object)null);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        Object impl;
        boolean debug;
        Map<String, Object> headers = new LinkedHashMap<String, Object>();
        String contextPath;
        String servletPath;

        Builder(Object impl) {
            this.impl = impl;
        }

        public Builder debug() {
            this.debug = true;
            this.header("X-Debug", true);
            return this;
        }

        public Builder noTrace() {
            this.header("X-NoTrace", true);
            return this;
        }

        public Builder header(String name, Object value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder headers(Map<String, Object> value) {
            if (value != null) {
                this.headers.putAll(value);
            } else {
                this.headers.clear();
            }
            return this;
        }

        public Builder accept(String value) {
            return this.header("Accept", value);
        }

        public Builder contentType(String value) {
            return this.header("Content-Type", value);
        }

        public Builder json() {
            return this.accept("application/json").contentType("application/json");
        }

        public Builder simpleJson() {
            return this.accept("application/json+simple").contentType("application/json+simple");
        }

        public Builder xml() {
            return this.accept("text/xml").contentType("text/xml");
        }

        public Builder html() {
            return this.accept("text/html").contentType("text/html");
        }

        public Builder plainText() {
            return this.accept("text/plain").contentType("text/plain");
        }

        public Builder msgpack() {
            return this.accept("octal/msgpack").contentType("octal/msgpack");
        }

        public Builder uon() {
            return this.accept("text/uon").contentType("text/uon");
        }

        public Builder urlEnc() {
            return this.accept("application/x-www-form-urlencoded").contentType("application/x-www-form-urlencoded");
        }

        public Builder yaml() {
            return this.accept("text/yaml").contentType("text/yaml");
        }

        public Builder openapi() {
            return this.accept("text/openapi").contentType("text/openapi");
        }

        public Builder serializer(Serializer value) {
            return this.contentType(value == null ? null : value.getPrimaryMediaType().toString());
        }

        public Builder parser(Parser value) {
            return this.accept(value == null ? null : value.getPrimaryMediaType().toString());
        }

        public Builder marshall(Marshall value) {
            this.contentType(value == null ? null : value.getSerializer().getPrimaryMediaType().toString());
            this.accept(value == null ? null : value.getParser().getPrimaryMediaType().toString());
            return this;
        }

        public Builder contextPath(String value) {
            RestUtils.validateContextPath((String)value);
            this.contextPath = value;
            return this;
        }

        public Builder servletPath(String value) {
            RestUtils.validateServletPath((String)value);
            this.servletPath = value;
            return this;
        }

        public MockRest build() {
            return new MockRest(this);
        }
    }
}

