/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ControllerDynamicThreadPool;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.config.DynamicProducerStateManagerConfig;
import org.apache.kafka.server.metrics.ClientTelemetryExporterPlugin;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015r!B*U\u0011\u0003If!B.U\u0011\u0003a\u0006\"B2\u0002\t\u0003!\u0007\u0002C3\u0002\u0005\u0004%\t\u0001\u00164\t\r]\f\u0001\u0015!\u0003h\u0011!A\u0018A1A\u0005\u0002QK\bBB?\u0002A\u0003%!\u0010C\u0004\u007f\u0003\t\u0007I\u0011\u00014\t\r}\f\u0001\u0015!\u0003h\u0011!\t\t!\u0001b\u0001\n\u0013I\bbBA\u0002\u0003\u0001\u0006IA\u001f\u0005\t\u0003\u000b\t!\u0019!C\u0005M\"9\u0011qA\u0001!\u0002\u00139\u0007\u0002CA\u0005\u0003\t\u0007I\u0011B=\t\u000f\u0005-\u0011\u0001)A\u0005u\"A\u0011QB\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002\u0010\u0005\u0001\u000b\u0011\u0002>\t\u0013\u0005E\u0011A1A\u0005\n\u0005M\u0001\u0002CA\u0013\u0003\u0001\u0006I!!\u0006\t\u000f\u0005\u001d\u0012\u0001\"\u0001\u0002*!9\u0011qL\u0001\u0005\u0002\u0005\u0005\u0004bBA>\u0003\u0011%\u0011Q\u0010\u0005\b\u0003\u0007\u000bA\u0011BAC\u0011\u001d\tI)\u0001C\u0005\u0003\u0017Cq!a$\u0002\t\u0013\t\t\n\u0003\u0005\u0002\u0016\u0006!\t\u0001VAL\u0011!\ty*\u0001C\u0001)\u0006\u0005\u0006\u0002CAT\u0003\u0011\u0005A+!+\u0007\u000bm#\u0006A!\u0001\t\u0015\t5AD!b\u0001\n\u0013\u0011y\u0001\u0003\u0006\u0003\u0012q\u0011\t\u0011)A\u0005\u0003/Daa\u0019\u000f\u0005\u0002\tM\u0001B\u0003B\r9\t\u0007I\u0011\u0001+\u0003\u001c!A!\u0011\u0005\u000f!\u0002\u0013\u0011i\u0002\u0003\u0006\u0003$q\u0011\r\u0011\"\u0001U\u00057A\u0001B!\n\u001dA\u0003%!Q\u0004\u0005\n\u0005Oa\"\u0019!C\u0005\u0005SA\u0001B!\f\u001dA\u0003%!1\u0006\u0005\n\u0005_a\"\u0019!C\u0005\u0005SA\u0001B!\r\u001dA\u0003%!1\u0006\u0005\u000b\u0005ga\"\u0019!C\u0001)\nU\u0002\u0002\u0003B&9\u0001\u0006IAa\u000e\t\u0013\t5CD1A\u0005\n\t=\u0003\u0002\u0003B-9\u0001\u0006IA!\u0015\t\u0013\tmCD1A\u0005\n\tu\u0003\u0002\u0003B69\u0001\u0006IAa\u0018\t\u0017\t5D\u00041AA\u0002\u0013%!q\u000e\u0005\f\u0005\u0007c\u0002\u0019!a\u0001\n\u0013\u0011)\tC\u0006\u0003\fr\u0001\r\u0011!Q!\n\tE\u0004b\u0003BG9\u0001\u0007\t\u0019!C\u0005\u0005\u001fA1Ba$\u001d\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0012\"Y!Q\u0013\u000fA\u0002\u0003\u0005\u000b\u0015BAl\u0011!\u00119\n\bC\u0001)\ne\u0005\u0002\u0003BP9\u0011\u0005AK!)\t\u000f\t\rF\u0004\"\u0001\u0003&\"9!1\u0015\u000f\u0005\u0002\tE\u0006b\u0002B_9\u0011\u0005!q\u0018\u0005\b\u0005\u000bdB\u0011\u0001Bd\u0011\u001d\u0011)\r\bC\u0001\u0005'DqAa6\u001d\t\u0003\u0011I\u000eC\u0004\u0003^r!IAa8\t\u0011\t\u0015H\u0004\"\u0001U\u0005\u001fA\u0001Ba:\u001d\t\u0003!&\u0011\u001e\u0005\t\u0005_dB\u0011\u0001+\u0003j\"A!\u0011\u001f\u000f\u0005\u0002Q\u0013y\u0007\u0003\u0005\u0003tr!\t\u0001\u0016B{\u0011)\u0019I\u0001HI\u0001\n\u0003!61\u0002\u0005\t\u0007CaB\u0011\u0001+\u0004$!Q1\u0011\u0006\u000f\u0012\u0002\u0013\u0005Aka\u0003\t\u0011\r-B\u0004\"\u0001U\u0007[A\u0001ba\r\u001d\t\u0003!6Q\u0007\u0005\b\u0007waB\u0011BB\u001f\u0011!\u0019)\u0005\bC\u0001)\u000e\u001d\u0003bBB'9\u0011%1q\n\u0005\t\u0007+bB\u0011\u0001+\u0004X!91Q\u0010\u000f\u0005\n\r}\u0004bBBV9\u0011%1Q\u0016\u0005\b\u0007gcB\u0011BB[\u0011\u001d\u0019I\f\bC\u0005\u0007wC\u0011b!3\u001d#\u0003%Iaa\u0003\t\u000f\r-G\u0004\"\u0003\u0004N\"91q\u001c\u000f\u0005\n\r\u0005\bb\u0002C\u00049\u0011%A\u0011B\u0001\u0014\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017n\u001a\u0006\u0003+Z\u000baa]3sm\u0016\u0014(\"A,\u0002\u000b-\fgm[1\u0004\u0001A\u0011!,A\u0007\u0002)\n\u0019B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jON\u0011\u0011!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0016A\u0006#z]\u0006l\u0017nY*fGV\u0014\u0018\u000e^=D_:4\u0017nZ:\u0016\u0003\u001d\u00042\u0001[7p\u001b\u0005I'B\u00016l\u0003\u001diW\u000f^1cY\u0016T!\u0001\\0\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002oS\n\u00191+\u001a;\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018\u0001\u00027b]\u001eT\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002wc\n11\u000b\u001e:j]\u001e\fq\u0003R=oC6L7mU3dkJLG/_\"p]\u001aLwm\u001d\u0011\u0002C\u0011Kh.Y7jGB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0003i\u00042a\u001f?p\u001b\u0005Y\u0017B\u00018l\u0003\t\"\u0015P\\1nS\u000e\u0004&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5hA\u0005\t\u0012\t\u001c7Es:\fW.[2D_:4\u0017nZ:\u0002%\u0005cG\u000eR=oC6L7mQ8oM&<7\u000fI\u0001\u001c\u00072,8\u000f^3s\u0019\u00164X\r\u001c'jgR,g.\u001a:D_:4\u0017nZ:\u00029\rcWo\u001d;fe2+g/\u001a7MSN$XM\\3s\u0007>tg-[4tA\u0005\u0001\u0002+\u001a:Ce>\\WM]\"p]\u001aLwm]\u0001\u0012!\u0016\u0014(I]8lKJ\u001cuN\u001c4jON\u0004\u0013\u0001\u0007'jgR,g.\u001a:NK\u000eD\u0017M\\5t[\u000e{gNZ5hg\u0006IB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:!\u0003U\u0011V\r\\8bI\u0006\u0014G.\u001a$jY\u0016\u001cuN\u001c4jON\faCU3m_\u0006$\u0017M\u00197f\r&dWmQ8oM&<7\u000fI\u0001\u0014\u0019&\u001cH/\u001a8fe\u000e{gNZ5h%\u0016<W\r_\u000b\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\tybX\u0001\u0005kRLG.\u0003\u0003\u0002$\u0005e!!\u0002*fO\u0016D\u0018\u0001\u0006'jgR,g.\u001a:D_:4\u0017n\u001a*fO\u0016D\b%\u0001\u000bce>\\WM]\"p]\u001aLwmU=o_:LXn\u001d\u000b\u0007\u0003W\t\t&!\u0016\u0011\r\u00055\u0012QHA\"\u001d\u0011\ty#!\u000f\u000f\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000eY\u0003\u0019a$o\\8u}%\t\u0001-C\u0002\u0002<}\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#\u0001\u0002'jgRT1!a\u000f`!\u0011\t)%!\u0014\u000f\t\u0005\u001d\u0013\u0011\n\t\u0004\u0003cy\u0016bAA&?\u00061\u0001K]3eK\u001aL1A^A(\u0015\r\tYe\u0018\u0005\b\u0003'\u001a\u0002\u0019AA\"\u0003\u0011q\u0017-\\3\t\u000f\u0005]3\u00031\u0001\u0002Z\u0005)R.\u0019;dQ2K7\u000f^3oKJ|e/\u001a:sS\u0012,\u0007c\u00010\u0002\\%\u0019\u0011QL0\u0003\u000f\t{w\u000e\\3b]\u0006ya/\u00197jI\u0006$XmQ8oM&<7\u000f\u0006\u0004\u0002d\u0005%\u0014q\u000f\t\u0004=\u0006\u0015\u0014bAA4?\n!QK\\5u\u0011\u001d\tY\u0007\u0006a\u0001\u0003[\nQ\u0001\u001d:paN\u0004B!a\u001c\u0002t5\u0011\u0011\u0011\u000f\u0006\u0004\u0003?\u0019\u0018\u0002BA;\u0003c\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\tI\b\u0006a\u0001\u00033\nq\u0002]3s\u0005J|7.\u001a:D_:4\u0017nZ\u0001\u0011a\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$B!a \u0002\u0002B!1\u0010`A\"\u0011\u001d\tY'\u0006a\u0001\u0003[\n\u0011C\\8o\tft\u0017-\\5d\u0007>tg-[4t)\u0011\ty(a\"\t\u000f\u0005-d\u00031\u0001\u0002n\u0005!3/Z2ve&$\u0018pQ8oM&<7oV5uQ>,H\u000fT5ti\u0016tWM\u001d)sK\u001aL\u0007\u0010\u0006\u0003\u0002\u0000\u00055\u0005bBA6/\u0001\u0007\u0011QN\u0001\u0014m\u0006d\u0017\u000eZ1uK\u000e{gNZ5h)f\u0004Xm\u001d\u000b\u0005\u0003G\n\u0019\nC\u0004\u0002la\u0001\r!!\u001c\u00021\u0011Lh.Y7jG\u000e{gNZ5h+B$\u0017\r^3N_\u0012,7/\u0006\u0002\u0002\u001aBA\u0011qNAN\u0003\u0007\n\u0019%\u0003\u0003\u0002\u001e\u0006E$aA'ba\u00061\"/Z:pYZ,g+\u0019:jC\ndWmQ8oM&<7\u000f\u0006\u0003\u0002n\u0005\r\u0006bBAS5\u0001\u0007\u0011QN\u0001\u000eaJ|\u0007o](sS\u001eLg.\u00197\u0002II,\u0017\r\u001a#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7O\u0012:p[Ns\u0017\r]:i_R$\"\"a\u0019\u0002,\u0006M\u0017Q\\Ax\u0011\u001d\tik\u0007a\u0001\u0003_\u000b1B]1gi6\u000bg.Y4feB1\u0011\u0011WA\\\u0003wk!!a-\u000b\u0007\u0005Uf+\u0001\u0003sC\u001a$\u0018\u0002BA]\u0003g\u0013\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u0011\t\u0005u\u0016qZ\u0007\u0003\u0003\u007fSA!!1\u0002D\u000611m\\7n_:T1!VAc\u0015\r9\u0016q\u0019\u0006\u0005\u0003\u0013\fY-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\f1a\u001c:h\u0013\u0011\t\t.a0\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0011\u001d\t)n\u0007a\u0001\u0003/\faaY8oM&<\u0007c\u0001.\u0002Z&\u0019\u00111\u001c+\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003?\\\u0002\u0019AAq\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgB!\u00111]Au\u001d\rQ\u0016Q]\u0005\u0004\u0003O$\u0016\u0001D)v_R\fg)Y2u_JL\u0018\u0002BAv\u0003[\u0014Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAAt)\"9\u0011\u0011_\u000eA\u0002\u0005M\u0018A\u00037pO\u000e{g\u000e^3yiB!\u0011Q_A\u007f\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018!B;uS2\u001c(\u0002BAa\u0003\u000bLA!a@\u0002x\nQAj\\4D_:$X\r\u001f;\u0014\tqi&1\u0001\t\u0005\u0005\u000b\u0011I!\u0004\u0002\u0003\b)\u0019\u0011\u0011 ,\n\t\t-!q\u0001\u0002\b\u0019><w-\u001b8h\u0003-Y\u0017MZ6b\u0007>tg-[4\u0016\u0005\u0005]\u0017\u0001D6bM.\f7i\u001c8gS\u001e\u0004C\u0003\u0002B\u000b\u0005/\u0001\"A\u0017\u000f\t\u000f\t5q\u00041\u0001\u0002X\u0006\u00192\u000f^1uS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011!Q\u0004\t\u0006Q\n}qn\\\u0005\u0004\u0003;K\u0017\u0001F:uCRL7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%\u0001\u000bti\u0006$\u0018n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm]\u0001\u0016gR\fG/[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:!\u0003Q!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011!1\u0006\t\bQ\n}\u00111IA\"\u0003U!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hg\u0002\nQ\u0003Z=oC6L7\rR3gCVdGoQ8oM&<7/\u0001\fes:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:!\u0003=\u0011XmY8oM&<WO]1cY\u0016\u001cXC\u0001B\u001c!\u0019\u0011IDa\u0010\u0003D5\u0011!1\b\u0006\u0005\u0005{\t\t(\u0001\u0006d_:\u001cWO\u001d:f]RLAA!\u0011\u0003<\t!2i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-\u001f'jgR\u0004BA!\u0012\u0003H5\u0011\u00111`\u0005\u0005\u0005\u0013\nYP\u0001\bSK\u000e|gNZ5hkJ\f'\r\\3\u0002!I,7m\u001c8gS\u001e,(/\u00192mKN\u0004\u0013!\u00062s_.,'OU3d_:4\u0017nZ;sC\ndWm]\u000b\u0003\u0005#\u0002bA!\u000f\u0003@\tM\u0003c\u0001.\u0003V%\u0019!q\u000b+\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003Y\u0011'o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKN\u0004\u0013\u0001\u00027pG.,\"Aa\u0018\u0011\t\t\u0005$qM\u0007\u0003\u0005GRAA!\u001a\u0003<\u0005)An\\2lg&!!\u0011\u000eB2\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017!\u00027pG.\u0004\u0013A\u0007;fY\u0016lW\r\u001e:z\u000bb\u0004xN\u001d;feBcWoZ5o\u001fB$XC\u0001B9!\u0015q&1\u000fB<\u0013\r\u0011)h\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\te$qP\u0007\u0003\u0005wRAA! \u0002D\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002\u0002BA\u0005w\u0012Qd\u00117jK:$H+\u001a7f[\u0016$(/_#ya>\u0014H/\u001a:QYV<\u0017N\\\u0001\u001fi\u0016dW-\\3uef,\u0005\u0010]8si\u0016\u0014\b\u000b\\;hS:|\u0005\u000f^0%KF$B!a\u0019\u0003\b\"I!\u0011R\u0018\u0002\u0002\u0003\u0007!\u0011O\u0001\u0004q\u0012\n\u0014a\u0007;fY\u0016lW\r\u001e:z\u000bb\u0004xN\u001d;feBcWoZ5o\u001fB$\b%A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\u0012GV\u0014(/\u001a8u\u0007>tg-[4`I\u0015\fH\u0003BA2\u0005'C\u0011B!#3\u0003\u0003\u0005\r!a6\u0002\u001d\r,(O]3oi\u000e{gNZ5hA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\t\u0005\r$1\u0014\u0005\b\u0005;#\u0004\u0019\u0001B9\u0003\u0001\u001aG.[3oiR+G.Z7fiJLX\t\u001f9peR,'\u000f\u00157vO&tw\n\u001d;\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005\r\u0014AE1eIJ+7m\u001c8gS\u001e,(/\u00192mKN$B!a\u0019\u0003(\"9!\u0011\u0016\u001cA\u0002\t-\u0016aC6bM.\f7+\u001a:wKJ\u00042A\u0017BW\u0013\r\u0011y\u000b\u0016\u0002\f\u0017\u000647.\u0019\"s_.,'\u000f\u0006\u0003\u0002d\tM\u0006b\u0002B[o\u0001\u0007!qW\u0001\u000bG>tGO]8mY\u0016\u0014\bc\u0001.\u0003:&\u0019!1\u0018+\u0003!\r{g\u000e\u001e:pY2,'oU3sm\u0016\u0014\u0018!E1eIJ+7m\u001c8gS\u001e,(/\u00192mKR!\u00111\rBa\u0011\u001d\u0011\u0019\r\u000fa\u0001\u0005\u0007\naB]3d_:4\u0017nZ;sC\ndW-A\fbI\u0012\u0014%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKR!\u00111\rBe\u0011\u001d\u0011\u0019-\u000fa\u0001\u0005\u0017\u0004BA!4\u0003R6\u0011!q\u001a\u0006\u0005\u0003+\f)-\u0003\u0003\u0003X\t=G\u0003BA2\u0005+DqAa1;\u0001\u0004\u0011\u0019&\u0001\u000bsK6|g/\u001a*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\u0005\u0003G\u0012Y\u000eC\u0004\u0003Dn\u0002\rAa\u0011\u00027Y,'/\u001b4z%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t)\u0011\t\u0019G!9\t\u000f\t\rH\b1\u0001\u0002\u0000\u0005Y1m\u001c8gS\u001et\u0015-\\3t\u0003I\u0019WO\u001d:f]R\\\u0015MZ6b\u0007>tg-[4\u00027\r,(O]3oi\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4t+\t\u0011Y\u000fE\u0004|\u0005[\f\u0019%a\u0011\n\u0007\u0005u5.\u0001\u000fdkJ\u0014XM\u001c;Es:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u0002;\rd\u0017.\u001a8u)\u0016dW-\\3uef,\u0005\u0010]8si\u0016\u0014\b\u000b\\;hS:\f!#\u001e9eCR,'I]8lKJ\u001cuN\u001c4jORA\u00111\rB|\u0007\u0003\u0019)\u0001C\u0004\u0003z\u0006\u0003\rAa?\u0002\u0011\t\u0014xn[3s\u0013\u0012\u00042A\u0018B\u007f\u0013\r\u0011yp\u0018\u0002\u0004\u0013:$\bbBB\u0002\u0003\u0002\u0007\u0011QN\u0001\u0010a\u0016\u00148/[:uK:$\bK]8qg\"I1qA!\u0011\u0002\u0003\u0007\u0011\u0011L\u0001\u0006I>dunZ\u0001\u001dkB$\u0017\r^3Ce>\\WM]\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iA\u000b\u0003\u0002Z\r=1FAB\t!\u0011\u0019\u0019b!\b\u000e\u0005\rU!\u0002BB\f\u00073\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rmq,\u0001\u0006b]:|G/\u0019;j_:LAaa\b\u0004\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002'U\u0004H-\u0019;f\t\u00164\u0017-\u001e7u\u0007>tg-[4\u0015\r\u0005\r4QEB\u0014\u0011\u001d\u0019\u0019a\u0011a\u0001\u0003[B\u0011ba\u0002D!\u0003\u0005\r!!\u0017\u0002;U\u0004H-\u0019;f\t\u00164\u0017-\u001e7u\u0007>tg-[4%I\u00164\u0017-\u001e7uII\nQE]3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3\u0015\t\u0005\r4q\u0006\u0005\b\u0007c)\u0005\u0019AA7\u0003!qWm\u001e)s_B\u001c\u0018a\u00054s_6\u0004VM]:jgR,g\u000e\u001e)s_B\u001cHCBA7\u0007o\u0019I\u0004C\u0004\u0004\u0004\u0019\u0003\r!!\u001c\t\u000f\u0005ed\t1\u0001\u0002Z\u0005\u0019b/\u00197jI\u0006$X\rZ&bM.\f\u0007K]8qgR1!1^B \u0007\u0007Bqa!\u0011H\u0001\u0004\ti'A\u0007qe>\u00048o\u0014<feJLG-\u001a\u0005\b\u0003s:\u0005\u0019AA-\u0003!1\u0018\r\\5eCR,GCBA2\u0007\u0013\u001aY\u0005C\u0004\u0002l!\u0003\r!!\u001c\t\u000f\u0005e\u0004\n1\u0001\u0002Z\u0005!\"/Z7pm\u0016LeN^1mS\u0012\u001cuN\u001c4jON$b!a\u0019\u0004R\rM\u0003bBA6\u0013\u0002\u0007\u0011Q\u000e\u0005\b\u0003sJ\u0005\u0019AA-\u0003Ai\u0017-\u001f2f%\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0005\u0002d\re31LB0\u0011\u001d\u0011\u0019M\u0013a\u0001\u0005\u0007Bqa!\u0018K\u0001\u0004\t9.A\u0005pY\u0012\u001cuN\u001c4jO\"91\u0011\r&A\u0002\r\r\u0014!\u00038fo\u000e{gNZ5ha\u0011\u0019)ga\u001b\u0011\u0011\u0005=\u00141TA\"\u0007O\u0002Ba!\u001b\u0004l1\u0001A\u0001DB7\u0007?\n\t\u0011!A\u0003\u0002\r=$aA0%cE!1\u0011OB<!\rq61O\u0005\u0004\u0007kz&a\u0002(pi\"Lgn\u001a\t\u0004=\u000ee\u0014bAB>?\n\u0019\u0011I\\=\u0002\u001dU\u0004H-\u0019;fI\u000e{gNZ5hgR11\u0011QBI\u0007;\u0003rAXBB\u0007\u000f\u000by(C\u0002\u0004\u0006~\u0013a\u0001V;qY\u0016\u0014\u0004\u0007BBE\u0007\u001b\u0003r\u0001\u001bB\u0010\u0003\u0007\u001aY\t\u0005\u0003\u0004j\r5EaCBH\u0017\u0006\u0005\t\u0011!B\u0001\u0007_\u00121a\u0018\u00135\u0011\u001d\u0019\td\u0013a\u0001\u0007'\u0003Da!&\u0004\u001aBA\u0011qNAN\u0003\u0007\u001a9\n\u0005\u0003\u0004j\reE\u0001DBN\u0007#\u000b\t\u0011!A\u0003\u0002\r=$aA0%e!91qT&A\u0002\r\u0005\u0016\u0001D2veJ,g\u000e\u001e)s_B\u001c\b\u0007BBR\u0007O\u0003\u0002\"a\u001c\u0002\u001c\u0006\r3Q\u0015\t\u0005\u0007S\u001a9\u000b\u0002\u0007\u0004*\u000eu\u0015\u0011!A\u0001\u0006\u0003\u0019yGA\u0002`IM\nQb\u001c<feJLG-\u001a)s_B\u001cHCBA2\u0007_\u001b\t\fC\u0004\u0002l1\u0003\rAa\u000b\t\u000f\r\u0005C\n1\u0001\u0003,\u0005\u0019R\u000f\u001d3bi\u0016\u001cUO\u001d:f]R\u001cuN\u001c4jOR!\u00111MB\\\u0011\u001d\u00199!\u0014a\u0001\u00033\na\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\t\u0007{\u001b\tma1\u0004HB9ala!\u0002X\u000e}\u0006CBA\u0017\u0003{\u0011\u0019\u0006C\u0004\u000429\u0003\rAa;\t\u000f\r\u0015g\n1\u0001\u0002Z\u0005aa/\u00197jI\u0006$Xm\u00148ms\"I1q\u0001(\u0011\u0002\u0003\u0007\u0011\u0011L\u0001!aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]\u0012\"WMZ1vYR$3'\u0001\u000boK\u0016$7OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\t\u00033\u001ayma6\u0004\\\"91\u0011\u001b)A\u0002\rM\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\t\u0007\u0003_\u001a).a\u0011\n\u00079\f\t\bC\u0004\u0004ZB\u0003\r!a \u0002\u0017U\u0004H-\u0019;fI.+\u0017p\u001d\u0005\b\u0007;\u0004\u0006\u0019AA@\u0003-!W\r\\3uK\u0012\\U-_:\u0002;A\u0014xnY3tg2K7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016$B\"a\u0019\u0004d\u000eM8Q\u001fC\u0001\t\u0007Aqa!:R\u0001\u0004\u00199/\u0001\fmSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f!\u0011\u0019Ioa<\u000e\u0005\r-(\u0002BBw\u0003w\fqA\\3uo>\u00148.\u0003\u0003\u0004r\u000e-(A\u0006'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\t\u000f\r\u0005\u0014\u000b1\u0001\u0002X\"91q_)A\u0002\re\u0018!D2vgR|WnQ8oM&<7\u000f\u0005\u0005\u0002p\u0005m\u00151IB~!\r\u00018Q`\u0005\u0004\u0007\u007f\f(AB(cU\u0016\u001cG\u000fC\u0004\u0004FF\u0003\r!!\u0017\t\u000f\u0011\u0015\u0011\u000b1\u0001\u0002Z\u0005Q!/\u001a7pC\u0012|e\u000e\\=\u0002+A\u0014xnY3tgJ+7m\u001c8gS\u001e,(/\u00192mKRa\u00111\rC\u0006\t\u001b!\t\u0002b\b\u0005$!9!1\u0019*A\u0002\t\r\u0003b\u0002C\b%\u0002\u0007\u0011qP\u0001\u0013kB$\u0017\r^3e\u0007>tg-[4OC6,7\u000fC\u0004\u0005\u0014I\u0003\r\u0001\"\u0006\u0002\u001b\u0005dGNT3x\u0007>tg-[4ta\u0011!9\u0002b\u0007\u0011\u0011\u0005=\u00141TA\"\t3\u0001Ba!\u001b\u0005\u001c\u0011aAQ\u0004C\t\u0003\u0003\u0005\tQ!\u0001\u0004p\t\u0019q\fJ\u001b\t\u000f\u0011\u0005\"\u000b1\u0001\u0004z\u0006\u0001b.Z<DkN$x.\\\"p]\u001aLwm\u001d\u0005\b\u0007\u000b\u0014\u0006\u0019AA-\u0001")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final CopyOnWriteArrayList<Reconfigurable> reconfigurables;
    private final CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private Option<ClientTelemetryExporterPlugin> telemetryExporterPluginOpt;
    private KafkaConfig currentConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(props, perBrokerConfig);
    }

    public static List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, matchListenerOverride);
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    public CopyOnWriteArrayList<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private Option<ClientTelemetryExporterPlugin> telemetryExporterPluginOpt() {
        return this.telemetryExporterPluginOpt;
    }

    private void telemetryExporterPluginOpt_$eq(Option<ClientTelemetryExporterPlugin> x$1) {
        this.telemetryExporterPluginOpt = x$1;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    public void initialize(Option<ClientTelemetryExporterPlugin> clientTelemetryExporterPluginOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false));
        this.telemetryExporterPluginOpt_$eq(clientTelemetryExporterPluginOpt);
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        kafkaServer.authorizerPlugin().foreach((Function1 & Serializable)plugin -> {
            DynamicBrokerConfig.$anonfun$addReconfigurables$1(this, plugin);
            return BoxedUnit.UNIT;
        });
        this.addReconfigurable((Reconfigurable)kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer.config(), kafkaServer.metrics(), kafkaServer.clusterId()));
        this.addReconfigurable(new DynamicClientQuotaCallback(kafkaServer.quotaManagers(), kafkaServer.config()));
        this.addBrokerReconfigurable(new BrokerDynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager()));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable((org.apache.kafka.config.BrokerReconfigurable)new DynamicProducerStateManagerConfig(kafkaServer.logManager().producerStateManagerConfig()));
        this.addBrokerReconfigurable(new DynamicRemoteLogConfig(kafkaServer));
    }

    public void addReconfigurables(ControllerServer controller) {
        controller.authorizerPlugin().foreach((Function1 & Serializable)plugin -> {
            DynamicBrokerConfig.$anonfun$addReconfigurables$2(this, plugin);
            return BoxedUnit.UNIT;
        });
        if (!this.kafkaConfig().processRoles().contains((Object)ProcessRole.BrokerRole)) {
            this.addReconfigurable((Reconfigurable)controller.kafkaYammerMetrics());
            this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().nodeId(), controller.config(), controller.metrics(), controller.clusterId()));
        }
        this.addReconfigurable(new DynamicClientQuotaCallback(controller.quotaManagers(), controller.config()));
        this.addBrokerReconfigurable(new ControllerDynamicThreadPool(controller));
        this.addBrokerReconfigurable(controller.socketServer());
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        this.verifyReconfigurableConfigs((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala());
        this.reconfigurables().add(reconfigurable);
    }

    public void addBrokerReconfigurable(org.apache.kafka.config.BrokerReconfigurable reconfigurable) {
        this.verifyReconfigurableConfigs((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala());
        this.brokerReconfigurables().add(new BrokerReconfigurable(null, reconfigurable){
            private final org.apache.kafka.config.BrokerReconfigurable reconfigurable$1;

            public Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsScala(this.reconfigurable$1.reconfigurableConfigs()).asScala();
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                this.reconfigurable$1.validateReconfiguration((AbstractConfig)newConfig);
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
                this.reconfigurable$1.reconfigure((AbstractConfig)oldConfig, (AbstractConfig)newConfig);
            }
            {
                this.reconfigurable$1 = reconfigurable$1;
            }
        });
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        this.verifyReconfigurableConfigs(reconfigurable.reconfigurableConfigs());
        this.brokerReconfigurables().add(reconfigurable);
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        this.reconfigurables().remove(reconfigurable);
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        Set nonDynamic = (Set)configNames.intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable)() -> "Reconfigurable contains non-dynamic configs " + nonDynamic);
    }

    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public Option<ClientTelemetryExporterPlugin> clientTelemetryExporterPlugin() {
        Option option;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = this.telemetryExporterPluginOpt();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, doLog, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateBrokerConfig$default$3() {
        return true;
    }

    public void updateDefaultConfig(Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps, doLog);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateDefaultConfig$default$2() {
        return true;
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        return props;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable)() -> "Dynamic " + configSource + " config contains invalid values in: " + invalidProps.keys() + ", these configs will be ignored", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
            return;
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(newProps).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(currentProps).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        propsOverride.foreachEntry((Function2 & Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable)key -> props.remove(key));
            return props.put(k, v);
        });
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig(boolean doLog) {
        void var5_5;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false, doLog);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        if (var5_5 != this.currentConfig()) {
            void var6_6;
            this.currentConfig_$eq((KafkaConfig)var5_5);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)var5_5);
            var6_6.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)var5_5, arg_0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly, boolean doLog) {
        void var7_7;
        void var6_6;
        KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(newProps).asJava(), doLog);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        if (var6_6.nonEmpty() || var7_7.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(k -> customConfigs.remove(k));
                this.reconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)var6_6, (Set)var7_7, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)var6_6, (Set)var7_7, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to update broker configuration with configs : " + ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef()), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)package$.MODULE$.List().empty());
    }

    private boolean processReconfiguration$default$3() {
        return false;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(updatedKeys).nonEmpty() || CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(deletedKeys).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        Set updatedKeys = var10_10.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)var11_11);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
            return;
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException("Validation of dynamic config update of " + updatedConfigNames + " failed with class " + reconfigurable.getClass());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Reconfiguring " + reconfigurable + ", updated configs: " + updatedConfigNames + " custom configs: " + ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef()));
            reconfigurable.reconfigure(newConfigs);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addReconfigurables$1(DynamicBrokerConfig $this, Plugin plugin) {
        Authorizer authorizer = (Authorizer)plugin.get();
        if (authorizer instanceof Reconfigurable) {
            $this.addReconfigurable((Reconfigurable)authorizer);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addReconfigurables$2(DynamicBrokerConfig $this, Plugin plugin) {
        Authorizer authorizer = (Authorizer)plugin.get();
        if (authorizer instanceof Reconfigurable) {
            $this.addReconfigurable((Reconfigurable)authorizer);
            return;
        }
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, boolean doLog$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> "Per-broker configs of " + brokerId$1 + " could not be applied: " + persistentProps$1.keys(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2, boolean doLog$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$2);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> "Cluster default configs could not be applied: " + persistentProps$2.keys(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        $this.reconfigurables().forEach(r -> {
            if (DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(r.reconfigurableConfigs(), arg_0))) {
                if (r instanceof ListenerReconfigurable) {
                    ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)r;
                    Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
                    KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(kafkaProps).asJava(), false);
                    $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
                    return;
                }
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Files will not be reloaded without config change for " + r);
                return;
            }
        });
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$3) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable)x$1 -> props$3.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage + ": " + invalidPropNames);
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$4, boolean perBrokerConfig$1) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$4, perBrokerConfig$1);
        return $this.processReconfiguration(newProps, true, false);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                return false;
            }
            catch (Exception exception) {
                return true;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            return !newProps$2.containsKey(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration(CollectionConverters$.MODULE$.SetHasAsJava(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
                return;
            }
            return;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        this.staticBrokerConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(KafkaConfig$.MODULE$.defaultValues()).asJava())).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = new CopyOnWriteArrayList();
        this.brokerReconfigurables = new CopyOnWriteArrayList();
        this.lock = new ReentrantReadWriteLock();
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$4) {
        x$4.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

