/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\u0012%\u0001%B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0005q!AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003H\u0011!\u0019\u0006A!b\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011e\u0003!Q1A\u0005\u0002iC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tE\u0002\u0011)\u0019!C\u0001G\"A\u0001\u000e\u0001B\u0001B\u0003%A\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!1\bA!A!\u0002\u0013)\u0006\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000ba\u0004A\u0011A=\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0003\t\u0013\u0005]\u0001A1A\u0005\n\u0005%\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0003\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA\u0017\u0001\u0001\u0006I!a\b\t\u0011\u0005=\u0002A1A\u0005\u0002]Bq!!\r\u0001A\u0003%\u0001\bC\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011Q\u0007\u0001!\u0002\u0013\tY\u0001C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!A\u0011\u0011\u000b\u0001!\u0002\u0013\tY\u0004C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002:!A\u0011Q\u000b\u0001!\u0002\u0013\tY\u0004C\u0005\u0002X\u0001\u0011\r\u0011\"\u0001\u0002Z!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0006C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0002\u0018\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM\u001d)p_2T!!\n\u0014\u0002\rM,'O^3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0004\u0001)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u00022i5\t!G\u0003\u00024M\u0005)Q\u000f^5mg&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003A\twm\u001a:fO\u0006$X\r\u00165sK\u0006$7/F\u00019!\tI$)D\u0001;\u0015\tYD(\u0001\u0004bi>l\u0017n\u0019\u0006\u0003{y\n!bY8oGV\u0014(/\u001a8u\u0015\ty\u0004)\u0001\u0003vi&d'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007j\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018!E1hOJ,w-\u0019;f)\"\u0014X-\u00193tA\u0005y\"/Z9vKN$\b*\u00198eY\u0016\u0014\u0018I^4JI2,W*\u001a;sS\u000et\u0015-\\3\u0016\u0003\u001d\u0003\"\u0001S(\u000f\u0005%k\u0005C\u0001&-\u001b\u0005Y%B\u0001')\u0003\u0019a$o\\8u}%\u0011a\nL\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002OY\u0005\u0001#/Z9vKN$\b*\u00198eY\u0016\u0014\u0018I^4JI2,W*\u001a;sS\u000et\u0015-\\3!\u0003!\u0011'o\\6fe&#W#A+\u0011\u0005-2\u0016BA,-\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u0001\\!\tav,D\u0001^\u0015\tqf%A\u0004oKR<xN]6\n\u0005\u0001l&A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA\u0005!\u0011\r]5t+\u0005!\u0007CA3g\u001b\u0005!\u0013BA4%\u0005E\t\u0005/\u001b*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u0006CBL7\u000fI\u0001\u0005i&lW\r\u0005\u0002li6\tAN\u0003\u00024[*\u0011an\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u001d\u0002(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!!\u001e7\u0003\tQKW.Z\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\u0018\u0001\u00038pI\u0016t\u0015-\\3\u0002\rqJg.\u001b;?)1Q8\u0010`?\u007f\u007f\u0006\u0005\u00111AA\u0003!\t)\u0007\u0001C\u00037\u001d\u0001\u0007\u0001\bC\u0003F\u001d\u0001\u0007q\tC\u0003T\u001d\u0001\u0007Q\u000bC\u0003Z\u001d\u0001\u00071\fC\u0003c\u001d\u0001\u0007A\rC\u0003j\u001d\u0001\u0007!\u000eC\u0003w\u001d\u0001\u0007Q\u000bC\u0003x\u001d\u0001\u0007q)\u0001\bnKR\u0014\u0018nY:QC\u000e\\\u0017mZ3\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001)\u0001\u0003mC:<\u0017b\u0001)\u0002\u0010\u0005yQ.\u001a;sS\u000e\u001c\b+Y2lC\u001e,\u0007%\u0001\tnKR\u0014\u0018nY:DY\u0006\u001c8OT1nK\u0006\tR.\u001a;sS\u000e\u001c8\t\\1tg:\u000bW.\u001a\u0011\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003Si!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\b[\u0016$(/[2t\u0015\t)s.\u0003\u0003\u0002,\u0005\r\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\na\u0002\u001e5sK\u0006$\u0007k\\8m'&TX-A\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3!\u0003Q\u0001XM\u001d)p_2LE\r\\3NKR,'OT1nK\u0006)\u0002/\u001a:Q_>d\u0017\n\u001a7f\u001b\u0016$XM\u001d(b[\u0016\u0004\u0013\u0001\u00059feB{w\u000e\\%eY\u0016lU\r^3s+\t\tY\u0004\u0005\u0003\u0002>\u00055SBAA \u0015\u0011\t\t%a\u0011\u0002\t\r|'/\u001a\u0006\u0005\u0003K\t)E\u0003\u0003\u0002H\u0005%\u0013AB=b[6,'O\u0003\u0002\u0002L\u0005\u00191m\\7\n\t\u0005=\u0013q\b\u0002\u0006\u001b\u0016$XM]\u0001\u0012a\u0016\u0014\bk\\8m\u0013\u0012dW-T3uKJ\u0004\u0013AE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ\f1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002\n\u0011B];o]\u0006\u0014G.Z:\u0016\u0005\u0005m\u0003CBA/\u0003O\nY'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u001diW\u000f^1cY\u0016T1!!\u001a-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\nyFA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA3\u0002n%\u0019\u0011q\u000e\u0013\u0003'-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:\u0002\u0015I,hN\\1cY\u0016\u001c\b%A\u0007de\u0016\fG/\u001a%b]\u0012dWM\u001d\u000b\u0005\u0003o\ni\bE\u0002,\u0003sJ1!a\u001f-\u0005\u0011)f.\u001b;\t\r\u0005}t\u00041\u0001V\u0003\tIG-A\u0007eK2,G/\u001a%b]\u0012dWM\u001d\u000b\u0005\u0003o\n)\t\u0003\u0004\u0002\u0000\u0001\u0002\r!V\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$B!a\u001e\u0002\f\"1\u0011QR\u0011A\u0002U\u000bqA\\3x'&TX-\u0001\u0005tQV$Hm\\<o)\t\t9\b")
public class KafkaRequestHandlerPool
implements Logging {
    private final AtomicInteger aggregateThreads;
    private final String requestHandlerAvgIdleMetricName;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String nodeName;
    private final String metricsPackage;
    private final String metricsClassName;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicInteger threadPoolSize;
    private final String perPoolIdleMeterName;
    private final Meter perPoolIdleMeter;
    private final Meter aggregateIdleMeter;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicInteger aggregateThreads() {
        return this.aggregateThreads;
    }

    public String requestHandlerAvgIdleMetricName() {
        return this.requestHandlerAvgIdleMetricName;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private String metricsPackage() {
        return this.metricsPackage;
    }

    private String metricsClassName() {
        return this.metricsClassName;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private String perPoolIdleMeterName() {
        return this.perPoolIdleMeterName;
    }

    private Meter perPoolIdleMeter() {
        return this.perPoolIdleMeter;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    private void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.aggregateThreads(), this.perPoolIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time, this.nodeName));
        this.aggregateThreads().getAndIncrement();
        Runnable daemon_runnable = (Runnable)this.runnables().apply(id);
        String daemon_name = "data-plane-kafka-request-handler-" + id;
        Object var2_3 = null;
        Object var3_2 = null;
        new KafkaThread(daemon_name, daemon_runnable, true).start();
    }

    private void deleteHandler(int id) {
        ((KafkaRequestHandler)this.runnables().remove(id)).stop();
        this.aggregateThreads().getAndDecrement();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Resizing request handler thread pool size from " + currentSize + " to " + newSize);
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.deleteHandler(currentSize - i));
        }
        this.threadPoolSize().set(newSize);
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.aggregateThreads().addAndGet(-this.threadPoolSize().get());
        this.info((Function0<String>)(Function0 & Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(AtomicInteger aggregateThreads, String requestHandlerAvgIdleMetricName, int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String nodeName) {
        String string;
        this.aggregateThreads = aggregateThreads;
        this.requestHandlerAvgIdleMetricName = requestHandlerAvgIdleMetricName;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.nodeName = nodeName;
        this.metricsPackage = "kafka.server";
        this.metricsClassName = "KafkaRequestHandlerPool";
        this.metricsGroup = new KafkaMetricsGroup(this.metricsPackage(), this.metricsClassName());
        this.threadPoolSize = new AtomicInteger(numThreads);
        String string2 = nodeName;
        String string3 = "broker";
        if (string2 != null && string2.equals(string3)) {
            string = "BrokerRequestHandlerAvgIdlePercent";
        } else {
            String string4 = nodeName;
            String string5 = "controller";
            if (string4 != null && string4.equals(string5)) {
                string = "ControllerRequestHandlerAvgIdlePercent";
            } else {
                throw new IllegalArgumentException("Invalid node name:" + nodeName);
            }
        }
        this.perPoolIdleMeterName = string;
        this.perPoolIdleMeter = this.metricsGroup().newMeter(this.perPoolIdleMeterName(), "percent", TimeUnit.NANOSECONDS);
        this.aggregateIdleMeter = this.metricsGroup().newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS);
        this.logIdent_$eq("[data-plane Kafka Request Handler on " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(nodeName)) + " " + brokerId + "] ");
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
    }
}

