/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.mirror.MirrorHeartbeatConfig;
import org.apache.kafka.connect.mirror.MirrorHeartbeatTask;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.Scheduler;
import org.apache.kafka.connect.source.SourceConnector;

public class MirrorHeartbeatConnector
extends SourceConnector {
    private MirrorHeartbeatConfig config;
    private Scheduler scheduler;
    private Admin targetAdminClient;

    public MirrorHeartbeatConnector() {
    }

    MirrorHeartbeatConnector(MirrorHeartbeatConfig config) {
        this.config = config;
    }

    public void start(Map<String, String> props) {
        this.config = new MirrorHeartbeatConfig(props);
        this.targetAdminClient = this.config.forwardingAdmin(this.config.targetAdminConfig("heartbeats-target-admin"));
        this.scheduler = new Scheduler(((Object)((Object)this)).getClass(), this.config.entityLabel(), this.config.adminTimeout());
        this.scheduler.execute(this::createInternalTopics, "creating internal topics");
    }

    public void stop() {
        Utils.closeQuietly((AutoCloseable)this.scheduler, (String)"scheduler");
        Utils.closeQuietly((AutoCloseable)this.targetAdminClient, (String)"target admin client");
    }

    public Class<? extends Task> taskClass() {
        return MirrorHeartbeatTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (this.config.emitHeartbeatsInterval().isNegative()) {
            return List.of();
        }
        return List.of(this.config.originalsStrings());
    }

    public ConfigDef config() {
        return MirrorHeartbeatConfig.CONNECTOR_CONFIG_DEF;
    }

    public String version() {
        return AppInfoParser.getVersion();
    }

    public boolean alterOffsets(Map<String, String> config, Map<Map<String, ?>, Map<String, ?>> offsets) {
        for (Map.Entry<Map<String, ?>, Map<String, ?>> offsetEntry : offsets.entrySet()) {
            Map<String, ?> sourceOffset = offsetEntry.getValue();
            if (sourceOffset == null) continue;
            Map<String, ?> sourcePartition = offsetEntry.getKey();
            if (sourcePartition == null) {
                throw new ConnectException("Source partitions may not be null");
            }
            MirrorUtils.validateSourcePartitionString(sourcePartition, "sourceClusterAlias");
            MirrorUtils.validateSourcePartitionString(sourcePartition, "targetClusterAlias");
            MirrorUtils.validateSourceOffset(sourcePartition, sourceOffset, true);
        }
        return true;
    }

    private void createInternalTopics() {
        MirrorUtils.createSinglePartitionCompactedTopic(this.config.heartbeatsTopic(), this.config.heartbeatsTopicReplicationFactor(), this.targetAdminClient);
    }
}

