/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.OptionalLong;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Json;
import org.slf4j.Logger;

public class CleanShutdownFileHandler {
    public static final String CLEAN_SHUTDOWN_FILE_NAME = ".kafka_cleanshutdown";
    final File cleanShutdownFile;
    private static final int CURRENT_VERSION = 0;
    private final Logger logger = new LogContext().logger(CleanShutdownFileHandler.class);

    public CleanShutdownFileHandler(String dirPath) {
        this.cleanShutdownFile = new File(dirPath, CLEAN_SHUTDOWN_FILE_NAME);
    }

    public void write(long brokerEpoch) throws Exception {
        this.write(brokerEpoch, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(long brokerEpoch, int version) throws Exception {
        FileOutputStream os = new FileOutputStream(this.cleanShutdownFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
        try {
            Content content = new Content(version, brokerEpoch);
            bw.write(Json.encodeAsString((Object)content));
            bw.flush();
            os.getFD().sync();
        }
        finally {
            bw.close();
            os.close();
        }
    }

    public OptionalLong read() {
        try {
            String text = Utils.readFileAsString((String)this.cleanShutdownFile.toPath().toString());
            Content content = (Content)Json.parseStringAs((String)text, Content.class);
            return OptionalLong.of(content.brokerEpoch);
        }
        catch (Exception e) {
            this.logger.debug("Fail to read the clean shutdown file in {}", (Object)this.cleanShutdownFile.toPath(), (Object)e);
            return OptionalLong.empty();
        }
    }

    public void delete() throws Exception {
        Files.deleteIfExists(this.cleanShutdownFile.toPath());
    }

    public boolean exists() {
        return this.cleanShutdownFile.exists();
    }

    public String toString() {
        return "CleanShutdownFile=(file=" + this.cleanShutdownFile.toString() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Content {
        public int version;
        public Long brokerEpoch;

        public Content() {
        }

        public Content(int version, Long brokerEpoch) {
            this.version = version;
            this.brokerEpoch = brokerEpoch;
        }
    }
}

