/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import org.apache.logging.log4j.core.impl.ThreadContextDataProvider;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.status.StatusLogger;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLoggingConstants;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.log4j2.internal.LoggingManagedService;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.DefaultServiceLog;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.RegisteredService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogReaderService;

public class Activator
implements BundleActivator {
    private ServiceRegistration<?> m_RegistrationPaxLogging;
    private PaxLoggingServiceImpl m_PaxLogging;
    private RegisteredService<LogReaderService, LogReaderServiceImpl> logReaderInfo;
    private RegisteredService<EventAdminPoster, EventAdminPoster> eventAdminInfo;
    private RegisteredService<ConfigurationNotifier, ConfigurationNotifier> eventAdminConfigurationNotifierInfo;
    private BundleContext bundleContext;

    public void start(BundleContext bundleContext) throws Exception {
        this.sanityCheck();
        this.bundleContext = bundleContext;
        String levelName = BackendSupport.defaultLogLevel(bundleContext);
        DefaultServiceLog.setLogLevel(levelName);
        this.logReaderInfo = BackendSupport.createAndRegisterLogReaderService(bundleContext);
        this.eventAdminInfo = BackendSupport.eventAdminSupport(bundleContext);
        this.eventAdminConfigurationNotifierInfo = BackendSupport.eventAdminConfigurationNotifier(bundleContext);
        boolean cm = BackendSupport.isConfigurationAdminAvailable();
        ThreadContextDataInjector.contextDataProviders.clear();
        ThreadContextDataInjector.contextDataProviders.add(new ThreadContextDataProvider());
        if (!cm) {
            StatusLogger.getLogger().info("Configuration Admin is not available.");
        }
        this.m_PaxLogging = new PaxLoggingServiceImpl(bundleContext, this.logReaderInfo.getService(), this.eventAdminInfo.getService(), this.eventAdminConfigurationNotifierInfo.getService());
        String externalFile = BackendSupport.externalFile(bundleContext, "pax-logging.properties");
        Path configFilePath = Paths.get(externalFile, new String[0]);
        if (!configFilePath.toFile().isFile() && !externalFile.contains(",")) {
            StatusLogger.getLogger().info("Initializing Log4j2 using default configuration");
            this.m_PaxLogging.configureDefaults();
        } else {
            StatusLogger.getLogger().info("Initializing Log4j2 using " + configFilePath.toAbsolutePath());
            boolean nativeConfiguration = true;
            Hashtable<String, String> config = new Hashtable<String, String>();
            if (configFilePath.toFile().isFile() && (configFilePath.toFile().getName().endsWith(".properties") || configFilePath.toFile().getName().endsWith(".config") || configFilePath.toFile().getName().endsWith(".cfg"))) {
                try (FileInputStream inputStream = new FileInputStream(configFilePath.toFile());){
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    boolean nonNative = properties.stringPropertyNames().stream().anyMatch(key -> key.startsWith("log4j2."));
                    if (nonNative) {
                        nativeConfiguration = false;
                        StrSubstitutor strSubstitutor = new StrSubstitutor(System.getProperties());
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            String propValue = (String)entry.getValue();
                            propValue = strSubstitutor.replace(propValue);
                            ((Dictionary)config).put((String)entry.getKey(), propValue);
                        }
                    }
                }
            }
            if (nativeConfiguration) {
                StatusLogger.getLogger().info("Passing " + configFilePath.toAbsolutePath() + " to Log4j2");
                ((Dictionary)config).put("org.ops4j.pax.logging.log4j2.config.file", configFilePath.toAbsolutePath().toString());
            }
            this.m_PaxLogging.setDefaultConfiguration(config);
            this.m_PaxLogging.updated(null);
        }
        if (cm) {
            Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
            ((Dictionary)serviceProperties).put("service.pid", "org.ops4j.pax.logging");
            this.m_RegistrationPaxLogging = bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)new LoggingManagedService(this.m_PaxLogging), serviceProperties);
        }
        Hashtable<String, Integer> serviceProperties = new Hashtable<String, Integer>();
        ((Dictionary)serviceProperties).put("service.ranking", BackendSupport.paxLoggingServiceRanking(bundleContext));
        this.m_RegistrationPaxLogging = bundleContext.registerService(PaxLoggingConstants.LOGGING_LOGSERVICE_NAMES, (Object)this.m_PaxLogging, serviceProperties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.eventAdminInfo != null) {
            this.eventAdminInfo.close();
        }
        if (this.logReaderInfo != null) {
            this.logReaderInfo.close();
        }
        if (this.eventAdminConfigurationNotifierInfo != null) {
            this.eventAdminConfigurationNotifierInfo.close();
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        if (this.m_PaxLogging != null) {
            this.m_PaxLogging.shutdown();
            this.m_PaxLogging = null;
        }
        FallbackLogFactory.cleanup();
    }

    private void sanityCheck() {
        Bundle paxLoggingApi = FrameworkUtil.getBundle(PaxLoggingService.class);
        Bundle paxLoggingLog4J2 = FrameworkUtil.getBundle(this.getClass());
    }
}

