/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.parsing;

import java.lang.reflect.Method;
import javax.transaction.Transactional;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.apache.aries.transaction.annotations.Transaction;
import org.apache.aries.transaction.annotations.TransactionPropagationType;
import org.apache.aries.transaction.parsing.TxTypeConverter;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationParser
implements BeanProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationParser.class);
    private final ComponentDefinitionRegistry cdr;
    private final Interceptor interceptor;
    private final TxComponentMetaDataHelper helper;

    public AnnotationParser(ComponentDefinitionRegistry cdr, Interceptor i, TxComponentMetaDataHelper helper) {
        this.cdr = cdr;
        this.interceptor = i;
        this.helper = helper;
    }

    public void afterDestroy(Object arg0, String arg1) {
    }

    public Object afterInit(Object arg0, String arg1, BeanProcessor.BeanCreator arg2, BeanMetadata arg3) {
        return arg0;
    }

    public void beforeDestroy(Object arg0, String arg1) {
    }

    public Object beforeInit(Object bean, String beanName, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanData) {
        boolean shouldAssignInterceptor = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            shouldAssignInterceptor |= this.parseTxData(beanData, c);
        }
        if (shouldAssignInterceptor && !this.isInterceptorAssigned(beanData)) {
            LOGGER.debug("Adding transaction interceptor to bean {} with class {}.", (Object)beanName, bean.getClass());
            this.cdr.registerInterceptorWithComponent((ComponentMetadata)beanData, this.interceptor);
        }
        return bean;
    }

    private boolean parseTxData(BeanMetadata beanData, Class<?> c) {
        boolean shouldAssignInterceptor = false;
        TransactionPropagationType t = this.tryGetTransaction(c);
        if (t != null) {
            this.helper.setComponentTransactionData(this.cdr, (ComponentMetadata)beanData, t, "*");
            shouldAssignInterceptor = true;
        }
        for (Method m : c.getDeclaredMethods()) {
            try {
                if (beanData == null || this.helper.getComponentMethodTxAttribute((ComponentMetadata)beanData, m.getName()) != null || (t = this.tryGetTransaction(m)) == null) continue;
                this.assertAllowedModifier(m);
                this.helper.setComponentTransactionData(this.cdr, (ComponentMetadata)beanData, t, m.getName());
                shouldAssignInterceptor = true;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        return shouldAssignInterceptor;
    }

    private TransactionPropagationType tryGetTransaction(Class<?> clazz) {
        Transaction t = clazz.getAnnotation(Transaction.class);
        if (t != null) {
            return t.value();
        }
        Transactional jtaT = clazz.getAnnotation(Transactional.class);
        if (jtaT != null) {
            return TxTypeConverter.convert(jtaT.value());
        }
        return null;
    }

    private TransactionPropagationType tryGetTransaction(Method m) {
        Transaction t = m.getAnnotation(Transaction.class);
        if (t != null) {
            return t.value();
        }
        Transactional jtaT = m.getAnnotation(Transactional.class);
        if (jtaT != null) {
            return TxTypeConverter.convert(jtaT.value());
        }
        return null;
    }

    private boolean isInterceptorAssigned(BeanMetadata beanData) {
        for (Interceptor i : this.cdr.getInterceptors((ComponentMetadata)beanData)) {
            if (i != this.interceptor) continue;
            return true;
        }
        return false;
    }

    private void assertAllowedModifier(Method m) {
        int modifiers = m.getModifiers();
        if ((modifiers & 0xA) != 0) {
            throw new IllegalArgumentException(Constants.MESSAGES.getMessage("private.or.static.method", new Object[]{m}));
        }
    }
}

