/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.xml.sax.Attributes;

public class XMLCompositeDirectCollectionMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private static final String SPACE = " ";
    private DirectCollectionMapping xmlCompositeDirectCollectionMapping;
    private int index = -1;

    public XMLCompositeDirectCollectionMappingNodeValue(DirectCollectionMapping xmlCompositeDirectCollectionMapping) {
        this.xmlCompositeDirectCollectionMapping = xmlCompositeDirectCollectionMapping;
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        XPathFragment nextFragment = xPathFragment.getNextFragment();
        if (nextFragment == null || this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            return xPathFragment.isAttribute() || xPathFragment.nameIsText();
        }
        return nextFragment != null && (nextFragment.nameIsText() || nextFragment.isAttribute());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        Object objectValue;
        XPathFragment groupingFragment;
        if (this.xmlCompositeDirectCollectionMapping.isReadOnly()) {
            return false;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        Object collection = this.xmlCompositeDirectCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            AbstractNullPolicy wrapperNP = this.xmlCompositeDirectCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        Field xmlField = (Field)this.xmlCompositeDirectCollectionMapping.getField();
        if (iterator != null && cp.hasNext(iterator)) {
            groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else if (xmlField.usesSingleNode() && !this.xmlCompositeDirectCollectionMapping.isDefaultEmptyContainer()) {
            groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlCompositeDirectCollectionMapping.getWrapperNullPolicy() != null);
        }
        if (xmlField.usesSingleNode()) {
            StringBuilder stringValueStringBuilder = new StringBuilder();
            QName schemaType = null;
            if (xPathFragment != null && !xPathFragment.isAttribute() && !xPathFragment.nameIsText) {
                marshalRecord.openStartElement(xPathFragment, namespaceResolver);
            }
            while (cp.hasNext(iterator)) {
                objectValue = cp.next(iterator, session);
                schemaType = xmlField.getSchemaTypeForValue(objectValue = this.xmlCompositeDirectCollectionMapping.convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller()), session);
                String newValue = marshalRecord.getValueToWrite(schemaType, objectValue, (ConversionManager)session.getDatasourcePlatform().getConversionManager());
                if (newValue == null) continue;
                stringValueStringBuilder.append(newValue);
                if (!cp.hasNext(iterator)) continue;
                stringValueStringBuilder.append(SPACE);
            }
            XPathFragment groupingFragment2 = marshalRecord.openStartGroupingElements(namespaceResolver);
            if (xPathFragment != null && xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, stringValueStringBuilder.toString());
                marshalRecord.closeStartGroupingElements(groupingFragment2);
            } else {
                marshalRecord.closeStartGroupingElements(groupingFragment2);
                if (this.xmlCompositeDirectCollectionMapping.isCDATA()) {
                    marshalRecord.cdata(stringValueStringBuilder.toString());
                } else {
                    marshalRecord.characters(stringValueStringBuilder.toString());
                    if (xPathFragment != null && !xPathFragment.isAttribute() && !xPathFragment.nameIsText) {
                        marshalRecord.endElement(xPathFragment, namespaceResolver);
                    }
                }
            }
        } else {
            int valueSize = cp.sizeFor(collection);
            if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON() && (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays())) {
                marshalRecord.startCollection();
            }
            while (cp.hasNext(iterator)) {
                objectValue = cp.next(iterator, session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
            }
            if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON() && (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays())) {
                marshalRecord.endCollection();
            }
        }
        return true;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        if (this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            StringTokenizer stringTokenizer = new StringTokenizer(value);
            while (stringTokenizer.hasMoreTokens()) {
                this.addUnmarshalValue(unmarshalRecord, stringTokenizer.nextToken(), collection);
            }
        } else {
            this.addUnmarshalValue(unmarshalRecord, value, collection);
        }
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        Field xmlField = (Field)this.xmlCompositeDirectCollectionMapping.getField();
        XPathFragment lastXPathFragment = xmlField.getLastXPathFragment();
        if (lastXPathFragment.nameIsText()) {
            String type = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type != null) {
                String namespaceURI = null;
                int colonIndex = type.indexOf(58);
                if (colonIndex > -1) {
                    String prefix = type.substring(0, colonIndex);
                    namespaceURI = unmarshalRecord.resolveNamespacePrefix(prefix);
                    type = type.substring(colonIndex + 1);
                }
                unmarshalRecord.setTypeQName(new QName(namespaceURI, type));
            }
        } else if (lastXPathFragment.isAttribute() && !xmlField.usesSingleNode()) {
            String namespaceURI = lastXPathFragment.getNamespaceURI();
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            String value = atts.getValue(namespaceURI, lastXPathFragment.getLocalName());
            Object collection = unmarshalRecord.getContainerInstance(this);
            this.addUnmarshalValue(unmarshalRecord, value, collection);
        }
        return true;
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Field xmlField = (Field)this.xmlCompositeDirectCollectionMapping.getField();
        Object value = unmarshalRecord.getCharacters().toString();
        if (((String)value).length() == 0 && !xmlField.usesSingleNode() && this.xmlCompositeDirectCollectionMapping.getNullValue() != null) {
            value = this.xmlCompositeDirectCollectionMapping.getNullValue();
        }
        unmarshalRecord.resetStringBuffer();
        XPathFragment lastXPathFragment = xmlField.getLastXPathFragment();
        if (!lastXPathFragment.nameIsText()) {
            return;
        }
        if (xmlField.usesSingleNode()) {
            Object collection = unmarshalRecord.getContainerInstance(this);
            StringTokenizer stringTokenizer = new StringTokenizer((String)value);
            while (stringTokenizer.hasMoreTokens()) {
                this.addUnmarshalValue(unmarshalRecord, stringTokenizer.nextToken(), collection);
            }
        } else if (!unmarshalRecord.getXMLReader().isInCollection() && unmarshalRecord.isNil()) {
            unmarshalRecord.setAttributeValueNull(this);
        } else {
            Object collection = unmarshalRecord.getContainerInstance(this);
            this.addUnmarshalValue(unmarshalRecord, value, collection);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        Field xmlField = (Field)this.xmlCompositeDirectCollectionMapping.getField();
        Object value = unmarshalRecord.getCharacters().toString();
        if (((String)value).length() == 0 && !xmlField.usesSingleNode() && this.xmlCompositeDirectCollectionMapping.getNullValue() != null) {
            value = this.xmlCompositeDirectCollectionMapping.getNullValue();
        }
        unmarshalRecord.resetStringBuffer();
        if (xmlField.usesSingleNode() && value instanceof String) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)value);
            while (stringTokenizer.hasMoreTokens()) {
                this.addUnmarshalValue(unmarshalRecord, stringTokenizer.nextToken(), collection);
            }
        } else if (xmlField.getLastXPathFragment().nameIsText()) {
            if (!unmarshalRecord.getXMLReader().isInCollection() && unmarshalRecord.isNil()) {
                unmarshalRecord.setAttributeValueNull(this);
            } else {
                this.addUnmarshalValue(unmarshalRecord, value, collection);
            }
        }
    }

    private void addUnmarshalValue(UnmarshalRecord unmarshalRecord, Object value, Object collection) {
        if (unmarshalRecord.isNil() && unmarshalRecord.getXMLReader().isNullRepresentedByXsiNil(this.xmlCompositeDirectCollectionMapping.getNullPolicy())) {
            value = null;
        } else if (!this.isWhitespaceAware() && "".equals(value)) {
            value = null;
        }
        Field xmlField = (Field)this.xmlCompositeDirectCollectionMapping.getField();
        ConversionManager conversionManager = unmarshalRecord.getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = xmlField.getJavaClass(unmarshalRecord.getTypeQName(), conversionManager);
            value = conversionManager.convertObject(value, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(xmlField, value, conversionManager, unmarshalRecord);
        }
        value = this.xmlCompositeDirectCollectionMapping.convertDataValueToObjectValue(value, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
        if (value != null && value.getClass() == CoreClassConstants.STRING) {
            if (this.xmlCompositeDirectCollectionMapping.isCollapsingStringValues()) {
                value = conversionManager.collapseStringValue((String)value);
            } else if (this.xmlCompositeDirectCollectionMapping.isNormalizingStringValues()) {
                value = conversionManager.normalizeStringValue((String)value);
            }
        }
        unmarshalRecord.addAttributeValue(this, value, collection);
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeDirectCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlCompositeDirectCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if ((value = this.xmlCompositeDirectCollectionMapping.convertObjectValueToDataValue(value, session, marshalRecord.getMarshaller())) != null) {
            XPathFragment nextFragment;
            String defaultNamespaceURI;
            QName fieldValue;
            Field xmlField = (Field)this.xmlCompositeDirectCollectionMapping.getField();
            QName schemaType = xmlField.getSchemaTypeForValue(value, session);
            boolean isElementOpen = false;
            if (Constants.QNAME_QNAME.equals(schemaType) && ((fieldValue = (QName)value).getNamespaceURI() == null || fieldValue.getNamespaceURI().equals("")) && ((NamespaceResolver)marshalRecord.getNamespaceResolver()).getDefaultNamespaceURI() != null && (defaultNamespaceURI = namespaceResolver.getDefaultNamespaceURI()).equals(xPathFragment.getNamespaceURI()) && xPathFragment.getPrefix() == null) {
                String prefix = namespaceResolver.generatePrefix();
                String xPath = String.valueOf(prefix) + ':' + xPathFragment.getShortName();
                XPathFragment newFragment = new XPathFragment(xPath);
                newFragment.setNamespaceURI(defaultNamespaceURI);
                newFragment.setNextFragment(xPathFragment.getNextFragment());
                marshalRecord.openStartElement(newFragment, namespaceResolver);
                isElementOpen = true;
                marshalRecord.namespaceDeclaration(prefix, defaultNamespaceURI);
                marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                xPathFragment = newFragment;
            }
            if (!isElementOpen) {
                marshalRecord.openStartElement(xPathFragment, namespaceResolver);
            }
            if ((nextFragment = xPathFragment.getNextFragment()) != null && nextFragment.isAttribute()) {
                marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                marshalRecord.attribute(nextFragment, namespaceResolver, value, schemaType);
                marshalRecord.closeStartElement();
            } else {
                if (xmlField.isTypedTextField()) {
                    this.updateNamespaces(schemaType, marshalRecord, xmlField);
                }
                marshalRecord.closeStartElement();
                marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                marshalRecord.characters(schemaType, value, null, this.xmlCompositeDirectCollectionMapping.isCDATA());
            }
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            return true;
        }
        AbstractNullPolicy nullPolicy = this.xmlCompositeDirectCollectionMapping.getNullPolicy();
        if (nullPolicy.getMarshalNullRepresentation() != XMLNullRepresentationType.ABSENT_NODE) {
            marshalRecord.openStartElement(xPathFragment, namespaceResolver);
            XPathFragment nextFragment = xPathFragment.getNextFragment();
            nullPolicy.directMarshal(nextFragment, marshalRecord, object, session, namespaceResolver);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            return true;
        }
        return false;
    }

    @Override
    public DirectCollectionMapping getMapping() {
        return this.xmlCompositeDirectCollectionMapping;
    }

    @Override
    public boolean isWhitespaceAware() {
        return !this.xmlCompositeDirectCollectionMapping.getNullPolicy().isNullRepresentedByEmptyNode();
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return true;
    }
}

