/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.util;

import org.apache.kyuubi.shaded.util.SignalHandler;

public final class Signal {
    private final sun.misc.Signal iSignal;

    public int getNumber() {
        return this.iSignal.getNumber();
    }

    public String getName() {
        return this.iSignal.getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof Signal)) {
            return false;
        }
        Signal other1 = (Signal)other;
        return this.iSignal.equals(other1.iSignal);
    }

    public int hashCode() {
        return this.getNumber();
    }

    public String toString() {
        return this.iSignal.toString();
    }

    public Signal(String name) {
        this.iSignal = new sun.misc.Signal(name);
    }

    public static synchronized SignalHandler handle(Signal sig, SignalHandler handler) throws IllegalArgumentException {
        sun.misc.SignalHandler oldHandler = sun.misc.Signal.handle(sig.iSignal, SunMiscHandler.of(sig, handler));
        return KyuubiSignalHandler.of(sig.iSignal, oldHandler);
    }

    public static void raise(Signal sig) throws IllegalArgumentException {
        sun.misc.Signal.raise(sig.iSignal);
    }

    static final class KyuubiSignalHandler
    implements SignalHandler {
        private final sun.misc.Signal iSignal;
        private final sun.misc.SignalHandler iHandler;

        static SignalHandler of(sun.misc.Signal signal, sun.misc.SignalHandler handler) {
            if (handler == sun.misc.SignalHandler.SIG_DFL) {
                return SignalHandler.SIG_DFL;
            }
            if (handler == sun.misc.SignalHandler.SIG_IGN) {
                return SignalHandler.SIG_IGN;
            }
            if (handler instanceof SunMiscHandler) {
                return ((SunMiscHandler)handler).handler;
            }
            return new KyuubiSignalHandler(signal, handler);
        }

        KyuubiSignalHandler(sun.misc.Signal iSignal, sun.misc.SignalHandler iHandler) {
            this.iSignal = iSignal;
            this.iHandler = iHandler;
        }

        @Override
        public void handle(Signal sig) {
            this.iHandler.handle(this.iSignal);
        }

        public String toString() {
            return this.iHandler.toString();
        }
    }

    static final class SunMiscHandler
    implements sun.misc.SignalHandler {
        private final SignalHandler handler;
        private final Signal signal;

        static sun.misc.SignalHandler of(Signal signal, SignalHandler handler) {
            if (handler == SignalHandler.SIG_DFL) {
                return sun.misc.SignalHandler.SIG_DFL;
            }
            if (handler == SignalHandler.SIG_IGN) {
                return sun.misc.SignalHandler.SIG_IGN;
            }
            if (handler instanceof KyuubiSignalHandler) {
                return ((KyuubiSignalHandler)handler).iHandler;
            }
            return new SunMiscHandler(signal, handler);
        }

        private SunMiscHandler(Signal signal, SignalHandler handler) {
            this.handler = handler;
            this.signal = signal;
        }

        @Override
        public void handle(sun.misc.Signal ignore) {
            this.handler.handle(this.signal);
        }
    }
}

