/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.access;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class LogoutAccessToken
extends AbstractNiFiRegistryCommand<VoidResult> {
    public LogoutAccessToken() {
        super("logout-access-token", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Performs a logout for the given access token";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BEARER_TOKEN.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException, CommandException {
        String bearerToken = this.getRequiredArg(properties, CommandOption.BEARER_TOKEN);
        client.getAccessClient().logout(bearerToken);
        return VoidResult.getInstance();
    }
}

