/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.ErrorDetails;
import software.amazon.awssdk.services.s3.model.InventoryConfigurationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryTableConfigurationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryTableConfigurationResult> {
    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationState").getter(InventoryTableConfigurationResult.getter(InventoryTableConfigurationResult::configurationStateAsString)).setter(InventoryTableConfigurationResult.setter(Builder::configurationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState").unmarshallLocationName("ConfigurationState").build(), RequiredTrait.create()}).build();
    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableStatus").getter(InventoryTableConfigurationResult.getter(InventoryTableConfigurationResult::tableStatus)).setter(InventoryTableConfigurationResult.setter(Builder::tableStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").unmarshallLocationName("TableStatus").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(InventoryTableConfigurationResult.getter(InventoryTableConfigurationResult::error)).setter(InventoryTableConfigurationResult.setter(Builder::error)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").unmarshallLocationName("Error").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(InventoryTableConfigurationResult.getter(InventoryTableConfigurationResult::tableName)).setter(InventoryTableConfigurationResult.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").unmarshallLocationName("TableName").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(InventoryTableConfigurationResult.getter(InventoryTableConfigurationResult::tableArn)).setter(InventoryTableConfigurationResult.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").unmarshallLocationName("TableArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_STATE_FIELD, TABLE_STATUS_FIELD, ERROR_FIELD, TABLE_NAME_FIELD, TABLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InventoryTableConfigurationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configurationState;
    private final String tableStatus;
    private final ErrorDetails error;
    private final String tableName;
    private final String tableArn;

    private InventoryTableConfigurationResult(BuilderImpl builder) {
        this.configurationState = builder.configurationState;
        this.tableStatus = builder.tableStatus;
        this.error = builder.error;
        this.tableName = builder.tableName;
        this.tableArn = builder.tableArn;
    }

    public final InventoryConfigurationState configurationState() {
        return InventoryConfigurationState.fromValue(this.configurationState);
    }

    public final String configurationStateAsString() {
        return this.configurationState;
    }

    public final String tableStatus() {
        return this.tableStatus;
    }

    public final ErrorDetails error() {
        return this.error;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryTableConfigurationResult)) {
            return false;
        }
        InventoryTableConfigurationResult other = (InventoryTableConfigurationResult)obj;
        return Objects.equals(this.configurationStateAsString(), other.configurationStateAsString()) && Objects.equals(this.tableStatus(), other.tableStatus()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableArn(), other.tableArn());
    }

    public final String toString() {
        return ToString.builder((String)"InventoryTableConfigurationResult").add("ConfigurationState", (Object)this.configurationStateAsString()).add("TableStatus", (Object)this.tableStatus()).add("Error", (Object)this.error()).add("TableName", (Object)this.tableName()).add("TableArn", (Object)this.tableArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationState": {
                return Optional.ofNullable(clazz.cast(this.configurationStateAsString()));
            }
            case "TableStatus": {
                return Optional.ofNullable(clazz.cast(this.tableStatus()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        map.put("TableStatus", TABLE_STATUS_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryTableConfigurationResult, T> g) {
        return obj -> g.apply((InventoryTableConfigurationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationState;
        private String tableStatus;
        private ErrorDetails error;
        private String tableName;
        private String tableArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryTableConfigurationResult model) {
            this.configurationState(model.configurationState);
            this.tableStatus(model.tableStatus);
            this.error(model.error);
            this.tableName(model.tableName);
            this.tableArn(model.tableArn);
        }

        public final String getConfigurationState() {
            return this.configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(InventoryConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        public final String getTableStatus() {
            return this.tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        public final ErrorDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public InventoryTableConfigurationResult build() {
            return new InventoryTableConfigurationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryTableConfigurationResult> {
        public Builder configurationState(String var1);

        public Builder configurationState(InventoryConfigurationState var1);

        public Builder tableStatus(String var1);

        public Builder error(ErrorDetails var1);

        default public Builder error(Consumer<ErrorDetails.Builder> error) {
            return this.error((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(error)).build());
        }

        public Builder tableName(String var1);

        public Builder tableArn(String var1);
    }
}

