/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.remote.exception.TransmissionDisabledException;

public class InterruptableInputStream
extends InputStream {
    private volatile boolean interrupted = false;
    private final InputStream in;

    public InterruptableInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        return this.in.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        return this.in.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        return this.in.skip(n);
    }

    public void interrupt() {
        this.interrupted = true;
    }
}

