/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.ott.InvalidOneTimeTokenException;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationToken;
import org.springframework.security.authentication.ott.OneTimeTokenService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public final class OneTimeTokenAuthenticationProvider
implements AuthenticationProvider {
    private final OneTimeTokenService oneTimeTokenService;
    private final UserDetailsService userDetailsService;

    public OneTimeTokenAuthenticationProvider(OneTimeTokenService oneTimeTokenService, UserDetailsService userDetailsService) {
        Assert.notNull((Object)oneTimeTokenService, (String)"oneTimeTokenService cannot be null");
        Assert.notNull((Object)userDetailsService, (String)"userDetailsService cannot be null");
        this.userDetailsService = userDetailsService;
        this.oneTimeTokenService = oneTimeTokenService;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OneTimeTokenAuthenticationToken otpAuthenticationToken = (OneTimeTokenAuthenticationToken)authentication;
        OneTimeToken consumed = this.oneTimeTokenService.consume(otpAuthenticationToken);
        if (consumed == null) {
            throw new InvalidOneTimeTokenException("Invalid token");
        }
        try {
            UserDetails user = this.userDetailsService.loadUserByUsername(consumed.getUsername());
            OneTimeTokenAuthenticationToken authenticated = OneTimeTokenAuthenticationToken.authenticated(user, user.getAuthorities());
            authenticated.setDetails(otpAuthenticationToken.getDetails());
            return authenticated;
        }
        catch (UsernameNotFoundException ex) {
            throw new BadCredentialsException("Failed to authenticate the one-time token");
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return OneTimeTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

