/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ActiveThreadInfo;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SchedulingAgentCallback;
import org.apache.nifi.controller.ThreadDetails;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.lifecycle.ProcessorStopLifecycleMethods;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;

public abstract class ProcessorNode
extends AbstractComponentNode
implements Connectable {
    public static final int DEFAULT_RETRY_COUNT = 10;
    public static final BackoffMechanism DEFAULT_BACKOFF_MECHANISM = BackoffMechanism.PENALIZE_FLOWFILE;
    public static final String DEFAULT_MAX_BACKOFF_PERIOD = "10 mins";
    protected final AtomicReference<ScheduledState> scheduledState = new AtomicReference<ScheduledState>(ScheduledState.STOPPED);

    public ProcessorNode(String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, String componentType, String componentCanonicalClass, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, serviceProvider, componentType, componentCanonicalClass, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
    }

    @Override
    public abstract boolean isIsolated();

    @Override
    public abstract boolean isTriggerWhenAnyDestinationAvailable();

    @Override
    public abstract boolean isSideEffectFree();

    public abstract boolean isTriggeredSerially();

    public abstract boolean isExecutionNodeRestricted();

    public abstract InputRequirement.Requirement getInputRequirement();

    public abstract List<ActiveThreadInfo> getActiveThreads(ThreadDetails var1);

    public abstract int getTerminatedThreadCount();

    public abstract void setBulletinLevel(LogLevel var1);

    public abstract LogLevel getBulletinLevel();

    public abstract Processor getProcessor();

    public abstract void setProcessor(LoggableComponent<Processor> var1);

    @Override
    public abstract void yield(long var1, TimeUnit var3);

    public abstract void setAutoTerminatedRelationships(Set<Relationship> var1);

    public abstract Set<Relationship> getAutoTerminatedRelationships();

    public abstract void setSchedulingStrategy(SchedulingStrategy var1);

    @Override
    public abstract SchedulingStrategy getSchedulingStrategy();

    public abstract void setExecutionNode(ExecutionNode var1);

    public abstract ExecutionNode getExecutionNode();

    public abstract void setRunDuration(long var1, TimeUnit var3);

    @Override
    public abstract long getRunDuration(TimeUnit var1);

    public abstract Map<String, String> getStyle();

    public abstract void setStyle(Map<String, String> var1);

    public abstract int getActiveThreadCount();

    public void verifyCanPerformVerification() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform verification because the Processor is not stopped");
        }
    }

    public abstract List<ConfigVerificationResult> verifyConfiguration(ProcessContext var1, ComponentLog var2, Map<String, String> var3, ExtensionManager var4);

    public abstract void verifyCanTerminate();

    public ScheduledState getScheduledState() {
        ScheduledState sc = this.scheduledState.get();
        if (sc == ScheduledState.STARTING) {
            ValidationStatus validationStatus = this.getValidationStatus();
            if (validationStatus == ValidationStatus.INVALID) {
                return ScheduledState.STOPPED;
            }
            return ScheduledState.RUNNING;
        }
        if (sc == ScheduledState.STOPPING) {
            return ScheduledState.STOPPED;
        }
        return sc;
    }

    public ScheduledState getPhysicalScheduledState() {
        return this.scheduledState.get();
    }

    public abstract void start(ScheduledExecutorService var1, long var2, long var4, Supplier<ProcessContext> var6, SchedulingAgentCallback var7, boolean var8, boolean var9);

    public abstract void runOnce(ScheduledExecutorService var1, long var2, long var4, Supplier<ProcessContext> var6, SchedulingAgentCallback var7);

    public abstract CompletableFuture<Void> stop(ProcessScheduler var1, ScheduledExecutorService var2, ProcessContext var3, SchedulingAgent var4, LifecycleState var5, ProcessorStopLifecycleMethods var6);

    public abstract void triggerOnUnscheduled(ProcessContext var1);

    public abstract int terminate();

    public abstract boolean isTerminated(Thread var1);

    public abstract void enable();

    public abstract void disable();

    public abstract ScheduledState getDesiredState();

    @Override
    protected void performFlowAnalysisOnThis() {
        this.getValidationContextFactory().getFlowAnalyzer().ifPresent(flowAnalyzer -> flowAnalyzer.analyzeProcessor(this));
    }

    public abstract void onConfigurationRestored(ProcessContext var1);

    public abstract void notifyPrimaryNodeChanged(PrimaryNodeState var1, LifecycleState var2);

    public abstract void migrateConfiguration(Map<String, String> var1, ControllerServiceFactory var2);
}

