/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nifi.processor.util.listen.event;

import org.apache.nifi.processor.util.listen.response.ChannelResponder;

import java.util.Map;

/**
 * EventFactory to create StandardEvent instances.
 */
@SuppressWarnings("PMD.UseDiamondOperator")
public class StandardEventFactory<T extends Event<?>> implements EventFactory<StandardEvent> {

    @Override
    public StandardEvent create(final byte[] data, final Map<String, String> metadata, final ChannelResponder responder) {
        String sender = null;
        String senderPort = null;
        if (metadata != null && metadata.containsKey(EventFactory.SENDER_KEY)) {
            sender = metadata.get(EventFactory.SENDER_KEY);
            senderPort = metadata.get(EventFactory.SENDER_PORT_KEY);
        }
        return new StandardEvent(sender, senderPort, data, responder);
    }

}
