/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetailsBeanPostProcessor;

class HikariJdbcConnectionDetailsBeanPostProcessor
extends JdbcConnectionDetailsBeanPostProcessor<HikariDataSource> {
    HikariJdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
        super(HikariDataSource.class, connectionDetailsProvider);
    }

    @Override
    protected Object processDataSource(HikariDataSource dataSource, JdbcConnectionDetails connectionDetails) {
        dataSource.setJdbcUrl(connectionDetails.getJdbcUrl());
        dataSource.setUsername(connectionDetails.getUsername());
        dataSource.setPassword(connectionDetails.getPassword());
        String driverClassName = connectionDetails.getDriverClassName();
        if (driverClassName != null) {
            dataSource.setDriverClassName(driverClassName);
        }
        return dataSource;
    }
}

