/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.persistence.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;

@AutoConfiguration
@ConditionalOnClass(value={PersistenceExceptionTranslationPostProcessor.class})
public final class PersistenceExceptionTranslationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.persistence.exceptiontranslation.enabled"}, matchIfMissing=true)
    static PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor(Environment environment) {
        PersistenceExceptionTranslationPostProcessor postProcessor = new PersistenceExceptionTranslationPostProcessor();
        boolean proxyTargetClass = (Boolean)environment.getProperty("spring.aop.proxy-target-class", Boolean.class, (Object)Boolean.TRUE);
        postProcessor.setProxyTargetClass(proxyTargetClass);
        return postProcessor;
    }
}

