/*
 * Decompiled with CFR 0.152.
 */
package org.archive.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class PerMapOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private String getOutputFilename(JobConf job) throws IOException {
        String regex = job.get("permap.regex", null);
        String replace = job.get("permap.replace", null);
        String suffix = job.get("permap.suffix", null);
        String inputFilename = job.get("map.input.file");
        if (inputFilename == null) {
            throw new IOException("map.input.file is null, not running in map task?");
        }
        String outputFilename = new Path(inputFilename).getName();
        if (regex != null && replace != null) {
            outputFilename = outputFilename.replaceAll(regex, replace);
        } else if (suffix != null) {
            outputFilename = outputFilename + suffix;
        }
        if (outputFilename == null) {
            throw new IOException("outputFilename is null");
        }
        return outputFilename;
    }

    private OutputFormat<K, V> getOutputFormat(JobConf job) {
        return (OutputFormat)ReflectionUtils.newInstance((Class)job.getClass("permap.output.format.class", SequenceFileOutputFormat.class, OutputFormat.class), (Configuration)job);
    }

    public RecordWriter<K, V> getRecordWriter(FileSystem fs, JobConf job, String name, Progressable progress) throws IOException {
        String outputFilename = this.getOutputFilename(job);
        OutputFormat<K, V> of = this.getOutputFormat(job);
        return of.getRecordWriter(fs, job, outputFilename, progress);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
    }
}

