/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import org.archive.url.URIException;
import org.archive.url.UsableURIFactory;
import org.archive.util.ArchiveUtils;
import org.archive.util.SurtPrefixSet;
import org.archive.util.TextUtils;

public class SURT {
    protected static char DOT = (char)46;
    protected static String BEGIN_TRANSFORMED_AUTHORITY = "(";
    protected static String TRANSFORMED_HOST_DELIM = ",";
    protected static String END_TRANSFORMED_AUTHORITY = ")";
    protected static String URI_SPLITTER = "^(\\w+://)(?:([-\\w\\.!~\\*'\\(\\)%;:&=+$,]+?)(@))?(?:((?:\\d{1,3}\\.){3}\\d{1,3})|(\\S+?))(:\\d+)?(/\\S*)?$";

    public static String fromURI(String s) {
        return SURT.fromURI(s, false);
    }

    public static String fromURI(String s, boolean preserveCase) {
        Matcher m = TextUtils.getMatcher(URI_SPLITTER, s);
        if (!m.matches()) {
            TextUtils.recycleMatcher(m);
            return s;
        }
        StringBuffer builder = new StringBuffer(s.length() + 3);
        SURT.append(builder, s, m.start(1), m.end(1));
        builder.append(BEGIN_TRANSFORMED_AUTHORITY);
        if (m.start(4) > -1) {
            SURT.append(builder, s, m.start(4), m.end(4));
        } else {
            int hostSegEnd = m.end(5);
            int hostStart = m.start(5);
            for (int i = m.end(5) - 1; i >= hostStart; --i) {
                if (s.charAt(i - 1) != DOT && i > hostStart) continue;
                SURT.append(builder, s, i, hostSegEnd);
                builder.append(TRANSFORMED_HOST_DELIM);
                hostSegEnd = i - 1;
            }
        }
        SURT.append(builder, s, m.start(6), m.end(6));
        SURT.append(builder, s, m.start(3), m.end(3));
        SURT.append(builder, s, m.start(2), m.end(2));
        builder.append(END_TRANSFORMED_AUTHORITY);
        SURT.append(builder, s, m.start(7), m.end(7));
        if (!preserveCase) {
            for (int i = 0; i < builder.length(); ++i) {
                builder.setCharAt(i, Character.toLowerCase(builder.charAt(i)));
            }
        }
        TextUtils.recycleMatcher(m);
        return builder.toString();
    }

    private static void append(StringBuffer b, CharSequence cs, int start, int end) {
        if (start < 0) {
            return;
        }
        b.append(cs, start, end);
    }

    public static String prefixFromPlain(String u) {
        u = SURT.fromPlain(u);
        u = SurtPrefixSet.asPrefix(u);
        return u;
    }

    public static String fromPlain(String u) {
        u = ArchiveUtils.addImpliedHttpIfNecessary(u);
        boolean trailingSlash = u.endsWith("/");
        try {
            u = UsableURIFactory.getInstance(u).toString();
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        if (!trailingSlash && u.endsWith("/")) {
            u = u.substring(0, u.length() - 1);
        }
        u = SURT.fromURI(u);
        return u;
    }

    public static void main(String[] args) throws IOException {
        String line;
        InputStream in = args.length > 0 ? new BufferedInputStream(new FileInputStream(args[0])) : System.in;
        PrintStream out = args.length > 1 ? new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(args[1])), false, StandardCharsets.UTF_8.name()) : System.out;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, Charset.defaultCharset()));
        while ((line = br.readLine()) != null) {
            if (line.indexOf("#") > 0) {
                line = line.substring(0, line.indexOf("#"));
            }
            if ((line = line.trim()).length() == 0) continue;
            line = ArchiveUtils.addImpliedHttpIfNecessary(line);
            out.println(SURT.fromURI(line));
        }
        br.close();
        out.close();
    }
}

