/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

public class CompensatedSum {
    private static final double NO_CORRECTION = 0.0;
    private double value;
    private double delta;

    public CompensatedSum(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    public double value() {
        return this.value;
    }

    public double delta() {
        return this.delta;
    }

    public CompensatedSum add(double value) {
        return this.add(value, 0.0);
    }

    public void reset(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    public CompensatedSum add(double value, double delta) {
        if (!Double.isFinite(value)) {
            this.value = value + this.value;
        }
        if (Double.isFinite(this.value)) {
            double correctedSum = value + (this.delta + delta);
            double updatedValue = this.value + correctedSum;
            this.delta = correctedSum - (updatedValue - this.value);
            this.value = updatedValue;
        }
        return this;
    }
}

