/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.ShadowRoot;

public class JsonToWebElementConverter
implements Function<Object, Object> {
    private final RemoteWebDriver driver;

    public JsonToWebElementConverter(RemoteWebDriver driver) {
        this.driver = driver;
    }

    @Override
    public Object apply(Object result) {
        if (result instanceof Collection) {
            Collection results = (Collection)result;
            return results.stream().map(this).collect(Collectors.toList());
        }
        if (result instanceof Map) {
            Map resultAsMap = (Map)result;
            String elementKey = this.getElementKey(resultAsMap);
            if (null != elementKey) {
                RemoteWebElement element = this.newRemoteWebElement();
                element.setId(String.valueOf(resultAsMap.get(elementKey)));
                return element;
            }
            String shadowKey = this.getShadowRootKey(resultAsMap);
            if (null != shadowKey) {
                return new ShadowRoot(this.driver, String.valueOf(resultAsMap.get(shadowKey)));
            }
            LinkedHashMap converted = new LinkedHashMap();
            resultAsMap.forEach((k, v) -> converted.put(k, this.apply(v)));
            return converted;
        }
        if (result instanceof RemoteWebElement) {
            return this.setOwner((RemoteWebElement)result);
        }
        if (result instanceof Number) {
            if (result instanceof Float || result instanceof Double) {
                return ((Number)result).doubleValue();
            }
            return ((Number)result).longValue();
        }
        return result;
    }

    protected RemoteWebElement newRemoteWebElement() {
        return this.setOwner(new RemoteWebElement());
    }

    private RemoteWebElement setOwner(RemoteWebElement element) {
        if (this.driver != null) {
            element.setParent(this.driver);
            element.setFileDetector(this.driver.getFileDetector());
        }
        return element;
    }

    private String getElementKey(Map<?, ?> resultAsMap) {
        for (Dialect d : Dialect.values()) {
            String elementKeyForDialect = d.getEncodedElementKey();
            if (!resultAsMap.containsKey(elementKeyForDialect)) continue;
            return elementKeyForDialect;
        }
        return null;
    }

    private String getShadowRootKey(Map<?, ?> resultAsMap) {
        for (Dialect d : Dialect.values()) {
            String shadowRootElementKey = d.getShadowRootElementKey();
            if (!resultAsMap.containsKey(shadowRootElementKey)) continue;
            return shadowRootElementKey;
        }
        return null;
    }
}

