/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.virtualauthenticator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VirtualAuthenticatorOptions {
    private Protocol protocol = Protocol.CTAP2;
    private Transport transport = Transport.USB;
    private boolean hasResidentKey = false;
    private boolean hasUserVerification = false;
    private boolean isUserConsenting = true;
    private boolean isUserVerified = false;

    public VirtualAuthenticatorOptions setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public VirtualAuthenticatorOptions setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public VirtualAuthenticatorOptions setHasResidentKey(boolean hasResidentKey) {
        this.hasResidentKey = hasResidentKey;
        return this;
    }

    public VirtualAuthenticatorOptions setHasUserVerification(boolean hasUserVerification) {
        this.hasUserVerification = hasUserVerification;
        return this;
    }

    public VirtualAuthenticatorOptions setIsUserConsenting(boolean isUserConsenting) {
        this.isUserConsenting = isUserConsenting;
        return this;
    }

    public VirtualAuthenticatorOptions setIsUserVerified(boolean isUserVerified) {
        this.isUserVerified = isUserVerified;
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protocol", this.protocol.id);
        map.put("transport", this.transport.id);
        map.put("hasResidentKey", this.hasResidentKey);
        map.put("hasUserVerification", this.hasUserVerification);
        map.put("isUserConsenting", this.isUserConsenting);
        map.put("isUserVerified", this.isUserVerified);
        return Collections.unmodifiableMap(map);
    }

    public static enum Protocol {
        CTAP2("ctap2"),
        U2F("ctap1/u2f");

        public final String id;

        private Protocol(String id) {
            this.id = id;
        }
    }

    public static enum Transport {
        BLE("ble"),
        INTERNAL("internal"),
        NFC("nfc"),
        USB("usb");

        public final String id;

        private Transport(String id) {
            this.id = id;
        }
    }
}

