/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.util.featuregen.StringPattern;

public class BagOfWordsFeatureGenerator
implements FeatureGenerator {
    private final boolean useOnlyAllLetterTokens;

    public BagOfWordsFeatureGenerator() {
        this(false);
    }

    BagOfWordsFeatureGenerator(boolean useOnlyAllLetterTokens) {
        this.useOnlyAllLetterTokens = useOnlyAllLetterTokens;
    }

    public Collection<String> extractFeatures(String[] text, Map<String, Object> extraInformation) {
        Objects.requireNonNull(text, "text must not be null");
        ArrayList<String> bagOfWords = new ArrayList<String>(text.length);
        for (String word : text) {
            if (this.useOnlyAllLetterTokens) {
                StringPattern pattern = StringPattern.recognize(word);
                if (!pattern.isAllLetter()) continue;
                bagOfWords.add("bow=" + word);
                continue;
            }
            bagOfWords.add("bow=" + word);
        }
        return bagOfWords;
    }
}

