/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.IOException;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;

public final class BekInfoUtils {
    private BekInfoUtils() {
    }

    public static OzoneManagerProtocolProtos.BucketEncryptionInfoProto getBekInfo(KeyProviderCryptoExtension kmsProvider, OzoneManagerProtocolProtos.BucketEncryptionInfoProto bek) throws IOException {
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto.Builder bekb = null;
        if (kmsProvider == null) {
            throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
        }
        if (bek.getKeyName() == null) {
            throw new OMException("Bucket encryption key needed.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        KeyProvider.Metadata metadata = kmsProvider.getMetadata(bek.getKeyName());
        if (metadata == null) {
            throw new OMException("Bucket encryption key " + bek.getKeyName() + " doesn't exist.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        kmsProvider.warmUpEncryptedKeys(new String[]{bek.getKeyName()});
        bekb = OzoneManagerProtocolProtos.BucketEncryptionInfoProto.newBuilder().setKeyName(bek.getKeyName()).setCryptoProtocolVersion(OzoneManagerProtocolProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES).setSuite(OMPBHelper.convert((CipherSuite)CipherSuite.convert((String)metadata.getCipher())));
        return bekb.build();
    }
}

