/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume.acl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeAclOpResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetAclRequest
extends OMVolumeAclRequest {
    private static final Logger LOG;
    private static final OMVolumeAclRequest.VolumeAclOp VOLUME_SET_ACL_OP;
    private final List<OzoneAcl> ozoneAcls;
    private final String volumeName;
    private final OzoneObj obj;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMVolumeSetAclRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMVolumeSetAclRequest.class);
        VOLUME_SET_ACL_OP = (acls, volArgs) -> {
            boolean bl = volArgs.setAcls(acls);
        };
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetAclRequest.Builder setAclRequestBuilder = this.getOmRequest().getSetAclRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetAclRequest(setAclRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    public OMVolumeSetAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, VOLUME_SET_ACL_OP);
        OzoneManagerProtocolProtos.SetAclRequest setAclRequest = this.getOmRequest().getSetAclRequest();
        Preconditions.checkNotNull((Object)setAclRequest);
        this.ozoneAcls = new ArrayList<OzoneAcl>();
        setAclRequest.getAclList().forEach(oai -> {
            boolean bl = this.ozoneAcls.add(OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)oai));
        });
        this.obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)setAclRequest.getObj());
        this.volumeName = this.obj.getPath().substring(1);
    }

    @Override
    public List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    OzoneObj getObject() {
        return this.obj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmVolumeArgs omVolumeArgs, boolean aclApplied) {
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(aclApplied).build());
        return new OMVolumeAclOpResponse(omResponse.build(), omVolumeArgs);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, Exception ex) {
        return new OMVolumeAclOpResponse(this.createErrorOMResponse(omResponse, ex));
    }

    @Override
    void onComplete(OMClientRequest.Result result, Exception ex, long trxnLogIndex, AuditLogger auditLogger, Map<String, String> auditMap) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Set acls: {} to volume: {} success!", this.getAcls(), (Object)this.getVolumeName());
                break;
            }
            case FAILURE: {
                LOG.error("Set acls {} to volume {} failed!", new Object[]{this.getAcls(), this.getVolumeName(), ex});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMVolumeSetAclRequest: {}", (Object)this.getOmRequest());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.SET_ACL, auditMap, ex, this.getOmRequest().getUserInfo()));
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        ozoneManager.getMetrics().incNumSetAcl();
        return super.validateAndUpdateCache(ozoneManager, context);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMVolumeSetAclRequest.java", OMVolumeSetAclRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeSetAclRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 58);
    }
}

