/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public abstract class AbstractOMKeyDeleteResponse
extends OmKeyResponse {
    public AbstractOMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    public AbstractOMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    protected void addDeletionToBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation, Table<String, ?> fromTable, String keyName, OmKeyInfo omKeyInfo, long bucketId, boolean isCommittedKey) throws IOException {
        fromTable.deleteWithBatch(batchOperation, (Object)keyName);
        if (!OmKeyInfo.isKeyEmpty((OmKeyInfo)omKeyInfo)) {
            omKeyInfo.setCommittedKeyDeletedFlag(isCommittedKey);
            RepeatedOmKeyInfo repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((long)bucketId, (OmKeyInfo)omKeyInfo, (long)omKeyInfo.getUpdateID());
            String delKeyName = omMetadataManager.getOzoneDeletePathKey(omKeyInfo.getObjectID(), keyName);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)delKeyName, (Object)repeatedOmKeyInfo);
        }
    }

    protected void addDeletionToBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation, Table<String, ?> fromTable, String keyName, String deleteKeyName, OmKeyInfo omKeyInfo, long bucketId, boolean isCommittedKey) throws IOException {
        fromTable.deleteWithBatch(batchOperation, (Object)keyName);
        if (!OmKeyInfo.isKeyEmpty((OmKeyInfo)omKeyInfo)) {
            omKeyInfo.setCommittedKeyDeletedFlag(isCommittedKey);
            RepeatedOmKeyInfo repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((long)bucketId, (OmKeyInfo)omKeyInfo, (long)omKeyInfo.getUpdateID());
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deleteKeyName, (Object)repeatedOmKeyInfo);
        }
    }

    @Override
    public abstract void addToDBBatch(OMMetadataManager var1, BatchOperation var2) throws IOException;
}

