/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.UuidCodec;
import org.apache.ratis.util.MemoizedSupplier;

public final class PipelineID {
    private static final Codec<PipelineID> CODEC = new DelegatedCodec<PipelineID, UUID>(UuidCodec.get(), PipelineID::valueOf, c -> c.id, PipelineID.class, DelegatedCodec.CopyType.SHALLOW);
    private final UUID id;
    private final Supplier<HddsProtos.PipelineID> protoSupplier;

    public static Codec<PipelineID> getCodec() {
        return CODEC;
    }

    private PipelineID(UUID id) {
        this.id = id;
        this.protoSupplier = MemoizedSupplier.valueOf(() -> PipelineID.buildProtobuf(id));
    }

    public static PipelineID randomId() {
        return new PipelineID(UUID.randomUUID());
    }

    public static PipelineID valueOf(UUID id) {
        return new PipelineID(id);
    }

    public static PipelineID valueOf(String id) {
        return PipelineID.valueOf(UUID.fromString(id));
    }

    public UUID getId() {
        return this.id;
    }

    @JsonIgnore
    public HddsProtos.PipelineID getProtobuf() {
        return this.protoSupplier.get();
    }

    static HddsProtos.PipelineID buildProtobuf(UUID id) {
        HddsProtos.UUID uuid128 = HddsProtos.UUID.newBuilder().setMostSigBits(id.getMostSignificantBits()).setLeastSigBits(id.getLeastSignificantBits()).build();
        return HddsProtos.PipelineID.newBuilder().setId(id.toString()).setUuid128(uuid128).build();
    }

    public static PipelineID getFromProtobuf(HddsProtos.PipelineID protos) {
        if (protos.hasUuid128()) {
            HddsProtos.UUID uuid = protos.getUuid128();
            return new PipelineID(new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits()));
        }
        if (protos.hasId()) {
            return new PipelineID(UUID.fromString(protos.getId()));
        }
        throw new IllegalArgumentException("Pipeline does not has uuid128 in proto");
    }

    public String toString() {
        return "Pipeline-" + this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineID that = (PipelineID)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

