/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.recon.ReconConstants;

public class NSSummary {
    private int numOfFiles;
    private long sizeOfFiles;
    private int[] fileSizeBucket;
    private Set<Long> childDir;
    private String dirName;
    private long parentId = 0L;

    public NSSummary() {
        this(0, 0L, new int[ReconConstants.NUM_OF_FILE_SIZE_BINS], new HashSet<Long>(), "", 0L);
    }

    public NSSummary(int numOfFiles, long sizeOfFiles, int[] bucket, Set<Long> childDir, String dirName, long parentId) {
        this.numOfFiles = numOfFiles;
        this.sizeOfFiles = sizeOfFiles;
        this.setFileSizeBucket(bucket);
        this.childDir = childDir;
        this.dirName = dirName;
        this.parentId = parentId;
    }

    public int getNumOfFiles() {
        return this.numOfFiles;
    }

    public long getSizeOfFiles() {
        return this.sizeOfFiles;
    }

    public int[] getFileSizeBucket() {
        return Arrays.copyOf(this.fileSizeBucket, ReconConstants.NUM_OF_FILE_SIZE_BINS);
    }

    public Set<Long> getChildDir() {
        return this.childDir;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setNumOfFiles(int numOfFiles) {
        this.numOfFiles = numOfFiles;
    }

    public void setSizeOfFiles(long sizeOfFiles) {
        this.sizeOfFiles = sizeOfFiles;
    }

    public void setFileSizeBucket(int[] fileSizeBucket) {
        this.fileSizeBucket = Arrays.copyOf(fileSizeBucket, ReconConstants.NUM_OF_FILE_SIZE_BINS);
    }

    public void setChildDir(Set<Long> childDir) {
        this.childDir = childDir;
    }

    public void setDirName(String dirName) {
        this.dirName = OzoneFSUtils.removeTrailingSlashIfNeeded((String)dirName);
    }

    public void addChildDir(long childId) {
        if (this.childDir.contains(childId)) {
            return;
        }
        this.childDir.add(childId);
    }

    public void removeChildDir(long childId) {
        if (this.childDir.contains(childId)) {
            this.childDir.remove(childId);
        }
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String toString() {
        return "NSSummary{dirName='" + this.dirName + '\'' + ", parentId=" + this.parentId + ", childDir=" + this.childDir + ", numOfFiles=" + this.numOfFiles + ", sizeOfFiles=" + this.sizeOfFiles + ", fileSizeBucket=" + Arrays.toString(this.fileSizeBucket) + '}';
    }
}

