/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.DecommissionUtils;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.datanode.NodeSelectionMixin;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.server.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="decommission", description={"Show status of datanodes in DECOMMISSIONING"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DecommissionStatusSubCommand
extends ScmSubcommand {
    private String errorMessage = "Error getting pipeline and container metrics for ";
    @CommandLine.Option(names={"--json"}, description={"Show output in json format"}, defaultValue="false")
    private boolean json;
    @CommandLine.Mixin
    private NodeSelectionMixin nodeSelectionMixin;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (!this.nodeSelectionMixin.getHostname().isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "--hostname option not supported for this command");
        }
        Stream allNodes = scmClient.queryNode(HddsProtos.NodeOperationalState.DECOMMISSIONING, null, HddsProtos.QueryScope.CLUSTER, "").stream();
        List decommissioningNodes = DecommissionUtils.getDecommissioningNodesList(allNodes, (String)this.nodeSelectionMixin.getNodeId(), (String)this.nodeSelectionMixin.getIp());
        if (!Strings.isNullOrEmpty((String)this.nodeSelectionMixin.getNodeId())) {
            if (decommissioningNodes.isEmpty()) {
                System.err.println("Datanode: " + this.nodeSelectionMixin.getNodeId() + " is not in DECOMMISSIONING");
                return;
            }
        } else if (!Strings.isNullOrEmpty((String)this.nodeSelectionMixin.getIp())) {
            if (decommissioningNodes.isEmpty()) {
                System.err.println("Datanode: " + this.nodeSelectionMixin.getIp() + " is not in DECOMMISSIONING");
                return;
            }
        } else if (!this.json) {
            System.out.println("\nDecommission Status: DECOMMISSIONING - " + decommissioningNodes.size() + " node(s)");
        }
        String metricsJson = scmClient.getMetrics("Hadoop:service=StorageContainerManager,name=NodeDecommissionMetrics");
        int numDecomNodes = -1;
        JsonNode jsonNode = null;
        if (metricsJson != null) {
            jsonNode = DecommissionUtils.getBeansJsonNode((String)metricsJson);
            numDecomNodes = DecommissionUtils.getNumDecomNodes((JsonNode)jsonNode);
        }
        if (this.json) {
            ArrayList decommissioningNodesDetails = new ArrayList();
            for (HddsProtos.Node node : decommissioningNodes) {
                DatanodeDetails datanode = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID());
                LinkedHashMap<String, Object> datanodeMap = new LinkedHashMap<String, Object>();
                datanodeMap.put("datanodeDetails", datanode);
                datanodeMap.put("metrics", this.getCounts(datanode, jsonNode, numDecomNodes));
                datanodeMap.put("containers", this.getContainers(scmClient, datanode));
                decommissioningNodesDetails.add(datanodeMap);
            }
            System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter(decommissioningNodesDetails));
            return;
        }
        for (HddsProtos.Node node : decommissioningNodes) {
            DatanodeDetails datanode = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID());
            this.printDetails(datanode);
            this.printCounts(datanode, jsonNode, numDecomNodes);
            Map containers = scmClient.getContainersOnDecomNode(datanode);
            System.out.println(containers);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private void printDetails(DatanodeDetails datanode) {
        System.out.println("\nDatanode: " + datanode.getUuid().toString() + " (" + datanode.getNetworkLocation() + "/" + datanode.getIpAddress() + "/" + datanode.getHostName() + ")");
    }

    private void printCounts(DatanodeDetails datanode, JsonNode counts, int numDecomNodes) {
        Map<String, Object> countsMap = this.getCounts(datanode, counts, numDecomNodes);
        System.out.println("Decommission Started At : " + countsMap.get("decommissionStartTime"));
        System.out.println("No. of Unclosed Pipelines: " + countsMap.get("numOfUnclosedPipelines"));
        System.out.println("No. of UnderReplicated Containers: " + countsMap.get("numOfUnderReplicatedContainers"));
        System.out.println("No. of Unclosed Containers: " + countsMap.get("numOfUnclosedContainers"));
    }

    private Map<String, Object> getCounts(DatanodeDetails datanode, JsonNode counts, int numDecomNodes) {
        Map<String, Object> countsMap = new LinkedHashMap<String, Object>();
        String errMsg = this.getErrorMessage() + datanode.getHostName();
        try {
            countsMap = DecommissionUtils.getCountsMap((DatanodeDetails)datanode, (JsonNode)counts, (int)numDecomNodes, countsMap, (String)errMsg);
            if (countsMap != null) {
                return countsMap;
            }
            System.err.println(errMsg);
        }
        catch (IOException e) {
            System.err.println(errMsg);
        }
        return countsMap;
    }

    private Map<String, Object> getContainers(ScmClient scmClient, DatanodeDetails datanode) throws IOException {
        Map containers = scmClient.getContainersOnDecomNode(datanode);
        return containers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ContainerID::toString).collect(Collectors.toList())));
    }
}

