/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3secret;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.s3.OzoneClientCache;
import org.apache.hadoop.ozone.s3.util.AuditUtils;

public class S3SecretEndpointBase
implements Auditor {
    private final OzoneConfiguration conf;
    private OzoneClient client;
    @Context
    private ContainerRequestContext context;
    protected static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.S3GLOGGER);

    @Inject
    S3SecretEndpointBase(OzoneConfiguration conf) {
        this.conf = new OzoneConfiguration((Configuration)conf);
        this.conf.setBoolean("ozone.s3.auth.check", false);
    }

    @PostConstruct
    void initialize() throws IOException {
        this.client = OzoneClientCache.createClient(this.conf);
    }

    protected String userNameFromRequest() {
        return this.context.getSecurityContext().getUserPrincipal().getName();
    }

    private AuditMessage.Builder auditMessageBaseBuilder(AuditAction op, Map<String, String> auditMap) {
        AuditMessage.Builder builder = new AuditMessage.Builder().forOperation(op).withParams(auditMap);
        if (this.context != null) {
            builder.atIp(AuditUtils.getClientIpAddress(this.context));
        }
        return builder;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        AuditMessage.Builder builder = this.auditMessageBaseBuilder(op, auditMap).withResult(AuditEventStatus.SUCCESS);
        return builder.build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        AuditMessage.Builder builder = this.auditMessageBaseBuilder(op, auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable);
        return builder.build();
    }

    public OzoneClient getClient() {
        return this.client;
    }

    @VisibleForTesting
    public void setClient(OzoneClient ozoneClient) {
        this.client = ozoneClient;
    }

    @VisibleForTesting
    public void setContext(ContainerRequestContext context) {
        this.context = context;
    }

    protected Map<String, String> getAuditParameters() {
        return AuditUtils.getAuditParameters(this.context);
    }
}

