/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.ListPaginationOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.PrefixFilterOption;
import org.apache.hadoop.ozone.shell.common.VolumeBucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"list all keys in a given volume or bucket or snapshot"})
public class ListKeyHandler
extends VolumeBucketHandler {
    @CommandLine.Mixin
    private ListPaginationOptions listOptions;
    @CommandLine.Mixin
    private PrefixFilterOption prefixFilter;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (!Strings.isNullOrEmpty((String)address.getBucketName())) {
            this.listKeysInsideBucket(client, address);
            return;
        }
        this.listKeysInsideVolume(client, address);
    }

    private void listKeysInsideBucket(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String snapshotNameWithIndicator = address.getSnapshotNameWithIndicator();
        String keyPrefix = "";
        if (!Strings.isNullOrEmpty((String)snapshotNameWithIndicator)) {
            keyPrefix = keyPrefix + snapshotNameWithIndicator;
            if (!Strings.isNullOrEmpty((String)this.prefixFilter.getPrefix())) {
                keyPrefix = keyPrefix + "/";
            }
        }
        if (!Strings.isNullOrEmpty((String)this.prefixFilter.getPrefix())) {
            keyPrefix = keyPrefix + this.prefixFilter.getPrefix();
        }
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        int maxKeyLimit = this.listOptions.getLimit();
        if (maxKeyLimit < bucket.getListCacheSize()) {
            bucket.setListCacheSize(maxKeyLimit);
        }
        Iterator keyIterator = bucket.listKeys(keyPrefix, this.listOptions.getStartItem());
        int counter = this.printAsJsonArray(keyIterator, maxKeyLimit);
        if (keyIterator.hasNext()) {
            this.err().println("Listing first " + maxKeyLimit + " entries of the result. Use --length (-l) to override max returned keys.");
        } else if (this.isVerbose()) {
            if (!Strings.isNullOrEmpty((String)snapshotNameWithIndicator)) {
                String[] snapshotValues = snapshotNameWithIndicator.split("/");
                this.err().printf("Found : %d keys for snapshot %s under bucket %s in volume : %s ", counter, snapshotValues[1], bucketName, volumeName);
            } else {
                this.err().printf("Found : %d keys for bucket %s in volume : %s ", counter, bucketName, volumeName);
            }
        }
    }

    private void listKeysInsideVolume(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        Iterator bucketIterator = vol.listBuckets(null);
        int maxKeyLimit = this.listOptions.getLimit();
        String keyPrefix = "";
        if (!Strings.isNullOrEmpty((String)this.prefixFilter.getPrefix())) {
            keyPrefix = keyPrefix + this.prefixFilter.getPrefix();
        }
        int totalKeys = 0;
        while (bucketIterator.hasNext()) {
            OzoneBucket bucket = (OzoneBucket)bucketIterator.next();
            Iterator keyIterator = bucket.listKeys(keyPrefix, this.listOptions.getStartItem());
            int counter = this.printAsJsonArray(keyIterator, maxKeyLimit);
            totalKeys += counter;
            if (!keyIterator.hasNext() && (!bucketIterator.hasNext() || (maxKeyLimit -= counter) > 0)) continue;
            this.err().println("Listing first " + totalKeys + " entries of the result. Use --length (-l) to override max returned keys.");
            return;
        }
        if (this.isVerbose()) {
            this.err().printf("Found : %d keys in volume : %s %n", totalKeys, volumeName);
        }
    }
}

