/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientCreator;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dcv", aliases={"datanode-chunk-validator"}, description={"Validate generated Chunks are the same "}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class DatanodeChunkValidator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeChunkValidator.class);
    @CommandLine.Option(names={"-l", "--pipeline"}, description={"Pipeline to use. By default the first RATIS/THREE pipeline will be used."}, defaultValue="")
    private String pipelineId;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated chunks (in bytes)"}, defaultValue="1024")
    private int chunkSize;
    private XceiverClientSpi xceiverClient;
    private Timer timer;
    private ChecksumData checksumReference;
    private Checksum checksum;
    private ContainerProtos.ChecksumData checksumProtobuf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConf = this.createOzoneConfiguration();
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)ozoneConf)) {
            throw new IllegalArgumentException("Datanode chunk validator is not supported in secure environment");
        }
        try (StorageContainerLocationProtocol scmClient = this.createStorageContainerLocationClient(ozoneConf);){
            Pipeline pipeline = DatanodeChunkValidator.findPipelineForTest(this.pipelineId, scmClient, LOG);
            try (XceiverClientCreator xceiverClientManager = new XceiverClientCreator((ConfigurationSource)ozoneConf);){
                this.xceiverClient = xceiverClientManager.acquireClientForReadData(pipeline);
                this.checksumProtobuf = ContainerProtos.ChecksumData.newBuilder().setBytesPerChecksum(4).setType(ContainerProtos.ChecksumType.CRC32).build();
                this.readReference();
                this.timer = this.getMetrics().timer("chunk-validate");
                this.runTests(this::validateChunk);
                xceiverClientManager.releaseClientForReadData(this.xceiverClient, true);
            }
        }
        finally {
            if (this.xceiverClient != null) {
                this.xceiverClient.close();
            }
        }
        return null;
    }

    private void readReference() throws IOException {
        ContainerProtos.ContainerCommandRequestProto request = this.createReadChunkRequest(0L);
        ContainerProtos.ContainerCommandResponseProto response = this.xceiverClient.sendCommand(request);
        this.checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, this.chunkSize);
        this.checksumReference = this.computeChecksum(response);
    }

    private void validateChunk(long stepNo) throws Exception {
        ContainerProtos.ContainerCommandRequestProto request = this.createReadChunkRequest(stepNo);
        this.timer.time(() -> {
            try {
                ContainerProtos.ContainerCommandResponseProto response = this.xceiverClient.sendCommand(request);
                ChecksumData checksumOfChunk = this.computeChecksum(response);
                if (!this.checksumReference.equals((Object)checksumOfChunk)) {
                    throw new IllegalStateException("Reference (=first) message checksum doesn't match with checksum of chunk " + response.getReadChunk().getChunkData().getChunkName());
                }
            }
            catch (IOException e) {
                LOG.warn("Could not read chunk due to IOException: ", (Throwable)e);
            }
        });
    }

    private ContainerProtos.ContainerCommandRequestProto createReadChunkRequest(long stepNo) throws IOException {
        ContainerProtos.DatanodeBlockID blockId = ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(1L).setLocalID(stepNo % 20L).build();
        ContainerProtos.ChunkInfo chunkInfo = ContainerProtos.ChunkInfo.newBuilder().setChunkName(this.getPrefix() + "_testdata_chunk_" + stepNo).setChecksumData(this.checksumProtobuf).setOffset(stepNo / 20L * (long)this.chunkSize).setLen((long)this.chunkSize).build();
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockId).setChunkData(chunkInfo);
        String id = this.xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockId.getContainerID()).setDatanodeUuid(id).setReadChunk(readChunkRequest);
        return builder.build();
    }

    private ChecksumData computeChecksum(ContainerProtos.ContainerCommandResponseProto response) throws OzoneChecksumException {
        ContainerProtos.ReadChunkResponseProto readChunk = response.getReadChunk();
        if (readChunk.hasData()) {
            return this.checksum.computeChecksum(readChunk.getData().asReadOnlyByteBuffer());
        }
        return this.checksum.computeChecksum(readChunk.getDataBuffers().getBuffersList());
    }
}

