/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.util.Optional;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.shell.ReplicationOptions;
import picocli.CommandLine;

public class FreonReplicationOptions
extends ReplicationOptions {
    private static final String FACTOR_OPT = "--factor";
    private ReplicationFactor factor;
    @CommandLine.Spec(value=CommandLine.Spec.Target.MIXEE)
    private CommandLine.Model.CommandSpec spec;

    @CommandLine.Option(names={"-F", "--factor"}, description={"[deprecated] Replication factor (ONE, THREE)"}, defaultValue="THREE")
    public void setFactor(ReplicationFactor factor) {
        this.factor = factor;
    }

    @CommandLine.Option(names={"--type", "--replication-type"}, description={"Replication type. Supported types are: RATIS, EC"})
    public void setType(String type) {
        super.setType(type);
    }

    @CommandLine.Option(names={"--replication", "-r"}, description={"Replication definition. Valid values are replication type-specific.  For RATIS: ONE or THREE. In case of EC, pass CODEC-DATA-PARITY-CHUNKSIZE,  e.g. rs-3-2-1024k, rs-6-3-1024k, rs-10-4-1024k"})
    public void setReplication(String replication) {
        super.setReplication(replication);
    }

    public Optional<ReplicationConfig> fromParams(ConfigurationSource conf) {
        if (this.spec != null && this.spec.commandLine().getParseResult() != null && this.spec.commandLine().getParseResult().hasMatchedOption(FACTOR_OPT)) {
            return Optional.of(ReplicationConfig.fromTypeAndFactor((ReplicationType)ReplicationType.RATIS, (ReplicationFactor)this.factor));
        }
        return super.fromParams(conf);
    }
}

