/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.datanode.schemaupgrade;

import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.util.Time;

class ContainerUpgradeResult {
    private final ContainerData originContainerData;
    private ContainerData newContainerData;
    private long totalRow = 0L;
    private final long startTimeMs = Time.monotonicNow();
    private long endTimeMs = 0L;
    private Status status = Status.FAIL;
    private String backupContainerFilePath;
    private String newContainerFilePath;

    ContainerUpgradeResult(ContainerData originContainerData) {
        this.originContainerData = originContainerData;
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setNewContainerData(ContainerData newContainerData) {
        this.newContainerData = newContainerData;
    }

    ContainerData getNewContainerData() {
        return this.newContainerData;
    }

    public long getCostMs() {
        return this.endTimeMs - this.startTimeMs;
    }

    public ContainerData getOriginContainerData() {
        return this.originContainerData;
    }

    public void setBackupContainerFilePath(String backupContainerFilePath) {
        this.backupContainerFilePath = backupContainerFilePath;
    }

    String getBackupContainerFilePath() {
        return this.backupContainerFilePath;
    }

    public void setNewContainerFilePath(String newContainerFilePath) {
        this.newContainerFilePath = newContainerFilePath;
    }

    String getNewContainerFilePath() {
        return this.newContainerFilePath;
    }

    public void success(long rowCount) {
        this.totalRow = rowCount;
        this.endTimeMs = Time.monotonicNow();
        this.status = Status.SUCCESS;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Result:{");
        stringBuilder.append("containerID=");
        stringBuilder.append(this.originContainerData.getContainerID());
        stringBuilder.append(", originContainerSchemaVersion=");
        stringBuilder.append(((KeyValueContainerData)this.originContainerData).getSchemaVersion());
        if (this.newContainerData != null) {
            stringBuilder.append(", schemaV2ContainerFileBackupPath=");
            stringBuilder.append(this.backupContainerFilePath);
            stringBuilder.append(", newContainerSchemaVersion=");
            stringBuilder.append(((KeyValueContainerData)this.newContainerData).getSchemaVersion());
            stringBuilder.append(", schemaV3ContainerFilePath=");
            stringBuilder.append(this.newContainerFilePath);
        }
        stringBuilder.append(", totalRow=");
        stringBuilder.append(this.totalRow);
        stringBuilder.append(", costMs=");
        stringBuilder.append(this.getCostMs());
        stringBuilder.append(", status=");
        stringBuilder.append((Object)this.status);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static enum Status {
        SUCCESS,
        FAIL;

    }
}

