/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import jakarta.annotation.Nullable;
import java.io.File;
import java.time.Duration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.utils.LeakDetector;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectMetrics;
import org.apache.ratis.util.UncheckedAutoCloseable;
import org.rocksdb.RocksDB;
import org.rocksdb.util.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagedRocksObjectUtils {
    static final Logger LOG = LoggerFactory.getLogger(ManagedRocksObjectUtils.class);
    private static final Duration POLL_INTERVAL_DURATION = Duration.ofMillis(100L);
    private static final LeakDetector LEAK_DETECTOR = new LeakDetector("ManagedRocksObject");

    private ManagedRocksObjectUtils() {
    }

    static UncheckedAutoCloseable track(AutoCloseable object) {
        ManagedRocksObjectMetrics.INSTANCE.increaseManagedObject();
        Class<?> clazz = object.getClass();
        StackTraceElement[] stackTrace = ManagedRocksObjectUtils.getStackTrace();
        return LEAK_DETECTOR.track((Object)object, () -> ManagedRocksObjectUtils.reportLeak(clazz, ManagedRocksObjectUtils.formatStackTrace(stackTrace)));
    }

    static void reportLeak(Class<?> clazz, String stackTrace) {
        ManagedRocksObjectMetrics.INSTANCE.increaseLeakObject();
        HddsUtils.reportLeak(clazz, (String)stackTrace, (Logger)LOG);
    }

    @Nullable
    private static StackTraceElement[] getStackTrace() {
        return HddsUtils.getStackTrace((Logger)LOG);
    }

    static String formatStackTrace(@Nullable StackTraceElement[] elements) {
        return HddsUtils.formatStackTrace((StackTraceElement[])elements, (int)4);
    }

    public static void waitForFileDelete(File file, Duration maxDuration) throws RocksDatabaseException {
        if (!RatisHelper.attemptUntilTrue(() -> !file.exists(), (Duration)POLL_INTERVAL_DURATION, (Duration)maxDuration)) {
            String msg = String.format("File: %s didn't get deleted in %s secs.", file.getAbsolutePath(), maxDuration.getSeconds());
            LOG.warn(msg);
            throw new RocksDatabaseException(msg);
        }
    }

    public static void loadRocksDBLibrary() {
        RocksDB.loadLibrary();
    }

    public static String getRocksDBLibFileName() {
        return Environment.getJniLibraryFileName((String)"rocksdb");
    }
}

