/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Constraint;
import org.jooq.DDLFlag;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.tools.StringUtils;

final class DDL {
    private final DSLContext ctx;
    private final EnumSet<DDLFlag> flags;

    DDL(DSLContext ctx, DDLFlag ... flags) {
        this.ctx = ctx;
        this.flags = EnumSet.noneOf(DDLFlag.class);
        for (DDLFlag flag : flags) {
            this.flags.add(flag);
        }
    }

    private final Query createTable(Table<?> table) {
        return this.ctx.createTable(table).columns(table.fields()).constraints(this.constraints(table));
    }

    private final List<Query> alterTableAddConstraints(Table<?> table) {
        List<Constraint> constraints = this.constraints(table);
        ArrayList<Query> result = new ArrayList<Query>(constraints.size());
        for (Constraint constraint : constraints) {
            result.add(this.ctx.alterTable(table).add(constraint));
        }
        return result;
    }

    private final List<Constraint> constraints(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        result.addAll(this.primaryKeys(table));
        result.addAll(this.uniqueKeys(table));
        result.addAll(this.foreignKeys(table));
        return result;
    }

    private List<Constraint> primaryKeys(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (this.flags.contains((Object)DDLFlag.PRIMARY_KEY)) {
            for (UniqueKey<?> key : table.getKeys()) {
                if (!key.isPrimary()) continue;
                result.add(DSL.constraint(key.getName()).primaryKey(key.getFieldsArray()));
            }
        }
        return result;
    }

    private List<Constraint> uniqueKeys(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (this.flags.contains((Object)DDLFlag.UNIQUE)) {
            for (UniqueKey<?> key : table.getKeys()) {
                if (key.isPrimary()) continue;
                result.add(DSL.constraint(key.getName()).unique(key.getFieldsArray()));
            }
        }
        return result;
    }

    private List<Constraint> foreignKeys(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (this.flags.contains((Object)DDLFlag.FOREIGN_KEY)) {
            for (ForeignKey<?, ?> key : table.getReferences()) {
                result.add(DSL.constraint(key.getName()).foreignKey(key.getFieldsArray()).references(key.getKey().getTable(), key.getKey().getFieldsArray()));
            }
        }
        return result;
    }

    final Queries queries(Table<?> ... tables) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Table<?> table : tables) {
            if (this.flags.contains((Object)DDLFlag.TABLE)) {
                queries.add(this.createTable(table));
            } else {
                queries.addAll(this.alterTableAddConstraints(table));
            }
            queries.addAll(this.commentOn(table));
        }
        return this.ctx.queries(queries);
    }

    private List<Query> commentOn(Table<?> table) {
        ArrayList<Query> result = new ArrayList<Query>();
        if (this.flags.contains((Object)DDLFlag.COMMENT)) {
            String tComment = table.getComment();
            if (!StringUtils.isEmpty(tComment)) {
                result.add(this.ctx.commentOnTable(table).is(tComment));
            }
            for (Field<?> field : table.fields()) {
                String fComment = field.getComment();
                if (StringUtils.isEmpty(fComment)) continue;
                result.add(this.ctx.commentOnColumn(field).is(fComment));
            }
        }
        return result;
    }

    final Queries queries(Schema schema) {
        ArrayList<Query> queries = new ArrayList<Query>();
        if (this.flags.contains((Object)DDLFlag.SCHEMA) && !StringUtils.isBlank(schema.getName())) {
            queries.add(this.ctx.createSchema(schema.getName()));
        }
        if (this.flags.contains((Object)DDLFlag.TABLE)) {
            for (Table<?> table : schema.getTables()) {
                ArrayList<Constraint> constraints = new ArrayList<Constraint>();
                constraints.addAll(this.primaryKeys(table));
                constraints.addAll(this.uniqueKeys(table));
                queries.add(this.ctx.createTable(table).columns(table.fields()).constraints(constraints));
            }
        } else {
            if (this.flags.contains((Object)DDLFlag.PRIMARY_KEY)) {
                for (Table<?> table : schema.getTables()) {
                    for (Constraint constraint : this.primaryKeys(table)) {
                        queries.add(this.ctx.alterTable(table).add(constraint));
                    }
                }
            }
            if (this.flags.contains((Object)DDLFlag.UNIQUE)) {
                for (Table<?> table : schema.getTables()) {
                    for (Constraint constraint : this.uniqueKeys(table)) {
                        queries.add(this.ctx.alterTable(table).add(constraint));
                    }
                }
            }
        }
        if (this.flags.contains((Object)DDLFlag.FOREIGN_KEY)) {
            for (Table<?> table : schema.getTables()) {
                for (Constraint constraint : this.foreignKeys(table)) {
                    queries.add(this.ctx.alterTable(table).add(constraint));
                }
            }
        }
        if (this.flags.contains((Object)DDLFlag.COMMENT)) {
            for (Table<?> table : schema.getTables()) {
                queries.addAll(this.commentOn(table));
            }
        }
        return this.ctx.queries(queries);
    }

    final Queries queries(Catalog catalog) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Schema schema : catalog.getSchemas()) {
            queries.addAll(Arrays.asList(this.queries(schema).queries()));
        }
        return this.ctx.queries(queries);
    }
}

