/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Catalog;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.CommentImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

public class SequenceImpl<T extends Number>
extends AbstractNamed
implements Sequence<T> {
    private static final long serialVersionUID = 6224349401603636427L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.SEQUENCE, Clause.SEQUENCE_REFERENCE};
    final String name;
    final boolean nameIsPlainSQL;
    final Schema schema;
    final DataType<T> type;

    public SequenceImpl(String name, Schema schema, DataType<T> type) {
        this(name, schema, type, false);
    }

    SequenceImpl(String name, Schema schema, DataType<T> type, boolean nameIsPlainSQL) {
        super(SequenceImpl.qualify(schema, DSL.name(name)), CommentImpl.NO_COMMENT);
        this.name = name;
        this.schema = schema;
        this.type = type;
        this.nameIsPlainSQL = nameIsPlainSQL;
    }

    @Override
    public final Catalog getCatalog() {
        return this.getSchema() == null ? null : this.getSchema().getCatalog();
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final DataType<T> getDataType() {
        return this.type;
    }

    @Override
    public final Field<T> currval() {
        return new SequenceFunction("currval");
    }

    @Override
    public final Field<T> nextval() {
        return new SequenceFunction("nextval");
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.accept0(ctx, false);
    }

    private final void accept0(Context<?> ctx, boolean asStringLiterals) {
        Schema mappedSchema = Tools.getMappedSchema(ctx.configuration(), this.schema);
        if (mappedSchema != null && !"".equals(mappedSchema.getName()) && ctx.family() != SQLDialect.CUBRID) {
            if (asStringLiterals) {
                ctx.visit(DSL.inline(mappedSchema.getName())).sql(", ");
            } else {
                ctx.visit(mappedSchema).sql('.');
            }
        }
        if (asStringLiterals) {
            ctx.visit(DSL.inline(this.name));
        } else if (this.nameIsPlainSQL) {
            ctx.sql(this.name);
        } else {
            ctx.literal(this.name);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private class SequenceFunction
    extends AbstractFunction<T> {
        private static final long serialVersionUID = 2292275568395094887L;
        private final String method;

        SequenceFunction(String method) {
            super(method, SequenceImpl.this.type, new Field[0]);
            this.method = method;
        }

        @Override
        final Field<T> getFunction0(Configuration configuration) {
            SQLDialect family = configuration.family();
            switch (family) {
                case POSTGRES: {
                    String field = this.method + "('" + this.getQualifiedName(configuration) + "')";
                    return DSL.field(field, this.getDataType());
                }
                case H2: {
                    String field = this.method + "(" + this.getQualifiedName(configuration, true) + ")";
                    return DSL.field(field, this.getDataType());
                }
                case FIREBIRD: 
                case DERBY: 
                case HSQLDB: {
                    if ("nextval".equals(this.method)) {
                        String field = "next value for " + this.getQualifiedName(configuration);
                        return DSL.field(field, this.getDataType());
                    }
                    if (family == SQLDialect.FIREBIRD) {
                        return DSL.field("gen_id(" + this.getQualifiedName(configuration) + ", 0)", this.getDataType());
                    }
                    throw new SQLDialectNotSupportedException("The sequence's current value functionality is not supported for the " + (Object)((Object)family) + " dialect.");
                }
                case CUBRID: {
                    String field = this.getQualifiedName(configuration) + ".";
                    field = "nextval".equals(this.method) ? field + "next_value" : field + "current_value";
                    return DSL.field(field, this.getDataType());
                }
            }
            String field = this.getQualifiedName(configuration) + "." + this.method;
            return DSL.field(field, this.getDataType());
        }

        private final String getQualifiedName(Configuration configuration) {
            return this.getQualifiedName(configuration, false);
        }

        private final String getQualifiedName(Configuration configuration, boolean asStringLiterals) {
            RenderContext local = this.create(configuration).renderContext();
            SequenceImpl.this.accept0(local, asStringLiterals);
            return local.render();
        }
    }
}

