/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.util.concurrent.Striped;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaPendingOpsSubscriber;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerMetrics;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ContainerReplicaPendingOps {
    private static final int RATIS_COUNTER_INDEX = 0;
    private static final int EC_COUNTER_INDEX = 1;
    private final Clock clock;
    private final ConcurrentHashMap<ContainerID, List<ContainerReplicaOp>> pendingOps = new ConcurrentHashMap();
    private final Striped<ReadWriteLock> stripedLock = Striped.readWriteLock((int)64);
    private final ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<ContainerReplicaOp.PendingOpType, AtomicLong[]> pendingOpCount = new ConcurrentHashMap();
    private ReplicationManagerMetrics replicationMetrics = null;
    private final List<ContainerReplicaPendingOpsSubscriber> subscribers = new ArrayList<ContainerReplicaPendingOpsSubscriber>();
    private final ConcurrentHashMap<DatanodeID, SizeAndTime> containerSizeScheduled = new ConcurrentHashMap();
    private ReplicationManager.ReplicationManagerConfiguration rmConf;

    public ContainerReplicaPendingOps(Clock clock) {
        this.clock = clock;
        this.resetCounters();
    }

    public ContainerReplicaPendingOps(Clock clock, ReplicationManager.ReplicationManagerConfiguration rmConf) {
        this(clock);
        this.rmConf = rmConf;
    }

    private void resetCounters() {
        for (ContainerReplicaOp.PendingOpType opType : ContainerReplicaOp.PendingOpType.values()) {
            AtomicLong[] counters = new AtomicLong[]{new AtomicLong(0L), new AtomicLong(0L)};
            this.pendingOpCount.put(opType, counters);
        }
    }

    public void clear() {
        this.globalLock.writeLock().lock();
        try {
            this.pendingOps.clear();
            this.resetCounters();
            this.containerSizeScheduled.clear();
        }
        finally {
            this.globalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerReplicaOp> getPendingOps(ContainerID containerID) {
        Lock lock = this.readLock(containerID);
        this.lock(lock);
        try {
            List<ContainerReplicaOp> ops = this.pendingOps.get(containerID);
            if (ops == null) {
                List<ContainerReplicaOp> list = Collections.emptyList();
                return list;
            }
            ArrayList<ContainerReplicaOp> arrayList = new ArrayList<ContainerReplicaOp>(ops);
            return arrayList;
        }
        finally {
            this.unlock(lock);
        }
    }

    public void scheduleAddReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex, SCMCommand<?> command, long deadlineEpochMillis, long containerSize, long scheduledEpochMillis) {
        this.addReplica(ContainerReplicaOp.PendingOpType.ADD, containerID, target, replicaIndex, command, deadlineEpochMillis, containerSize, scheduledEpochMillis);
    }

    public void scheduleDeleteReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex, SCMCommand<?> command, long deadlineEpochMillis) {
        this.addReplica(ContainerReplicaOp.PendingOpType.DELETE, containerID, target, replicaIndex, command, deadlineEpochMillis, 0L, this.clock.millis());
    }

    public boolean completeAddReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex) {
        boolean completed = this.completeOp(ContainerReplicaOp.PendingOpType.ADD, containerID, target, replicaIndex, true);
        if (this.isMetricsNotNull() && completed) {
            if (this.isEC(replicaIndex)) {
                this.replicationMetrics.incrEcReplicasCreatedTotal();
            } else {
                this.replicationMetrics.incrReplicasCreatedTotal();
            }
        }
        return completed;
    }

    public boolean completeDeleteReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex) {
        boolean completed = this.completeOp(ContainerReplicaOp.PendingOpType.DELETE, containerID, target, replicaIndex, true);
        if (this.isMetricsNotNull() && completed) {
            if (this.isEC(replicaIndex)) {
                this.replicationMetrics.incrEcReplicasDeletedTotal();
            } else {
                this.replicationMetrics.incrReplicasDeletedTotal();
            }
        }
        return completed;
    }

    public boolean removeOp(ContainerID containerID, ContainerReplicaOp op) {
        return this.completeOp(op.getOpType(), containerID, op.getTarget(), op.getReplicaIndex(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredEntries() {
        for (ContainerID containerID : this.pendingOps.keySet()) {
            ArrayList<ContainerReplicaOp> expiredOps;
            block8: {
                expiredOps = new ArrayList<ContainerReplicaOp>();
                Lock lock = this.writeLock(containerID);
                this.lock(lock);
                try {
                    List<ContainerReplicaOp> ops = this.pendingOps.get(containerID);
                    if (ops == null) continue;
                    ListIterator<ContainerReplicaOp> iterator = ops.listIterator();
                    while (iterator.hasNext()) {
                        ContainerReplicaOp op = (ContainerReplicaOp)iterator.next();
                        if (this.clock.millis() <= op.getDeadlineEpochMillis()) continue;
                        if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) {
                            iterator.remove();
                            if (op.getOpType() == ContainerReplicaOp.PendingOpType.ADD) {
                                this.releaseScheduledContainerSize(op);
                            }
                            this.decrementCounter(op.getOpType(), op.getReplicaIndex());
                        }
                        expiredOps.add(op);
                        this.updateTimeoutMetrics(op);
                    }
                    if (!ops.isEmpty()) break block8;
                    this.pendingOps.remove(containerID);
                }
                finally {
                    this.unlock(lock);
                    continue;
                }
            }
            if (expiredOps.isEmpty()) continue;
            this.notifySubscribers(expiredOps, containerID, true);
        }
    }

    private void releaseScheduledContainerSize(ContainerReplicaOp op) {
        this.containerSizeScheduled.computeIfPresent(op.getTarget().getID(), (k, v) -> {
            boolean hasOpExpired;
            long newSize = v.getSize() - op.getContainerSize();
            boolean isSizeNonPositive = newSize <= 0L;
            boolean bl = hasOpExpired = this.clock.millis() - v.getLastUpdatedTime() > this.rmConf.getEventTimeout();
            if (isSizeNonPositive || hasOpExpired) {
                return null;
            }
            return new SizeAndTime(newSize, v.getLastUpdatedTime());
        });
    }

    private void updateTimeoutMetrics(ContainerReplicaOp op) {
        if (op.getOpType() == ContainerReplicaOp.PendingOpType.ADD && this.isMetricsNotNull()) {
            if (this.isEC(op.getReplicaIndex())) {
                this.replicationMetrics.incrEcReplicaCreateTimeoutTotal();
            } else {
                this.replicationMetrics.incrReplicaCreateTimeoutTotal();
            }
        } else if (op.getOpType() == ContainerReplicaOp.PendingOpType.DELETE && this.isMetricsNotNull()) {
            if (this.isEC(op.getReplicaIndex())) {
                this.replicationMetrics.incrEcReplicaDeleteTimeoutTotal();
            } else {
                this.replicationMetrics.incrReplicaDeleteTimeoutTotal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplica(ContainerReplicaOp.PendingOpType opType, ContainerID containerID, DatanodeDetails target, int replicaIndex, SCMCommand<?> command, long deadlineEpochMillis, long containerSize, long scheduledEpochMillis) {
        Lock lock = this.writeLock(containerID);
        this.lock(lock);
        try {
            this.completeOp(opType, containerID, target, replicaIndex, false);
            List ops = this.pendingOps.computeIfAbsent(containerID, s -> new ArrayList());
            ops.add(new ContainerReplicaOp(opType, target, replicaIndex, command, deadlineEpochMillis, containerSize));
            DatanodeID id = target.getID();
            if (opType == ContainerReplicaOp.PendingOpType.ADD) {
                this.containerSizeScheduled.compute(id, (k, v) -> {
                    if (v == null) {
                        return new SizeAndTime(containerSize, scheduledEpochMillis);
                    }
                    return new SizeAndTime(v.getSize() + containerSize, scheduledEpochMillis);
                });
            }
            this.incrementCounter(opType, replicaIndex);
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeOp(ContainerReplicaOp.PendingOpType opType, ContainerID containerID, DatanodeDetails target, int replicaIndex, boolean notifySubsribers) {
        boolean found = false;
        ArrayList<ContainerReplicaOp> completedOps = new ArrayList<ContainerReplicaOp>();
        Lock lock = this.writeLock(containerID);
        this.lock(lock);
        try {
            List<ContainerReplicaOp> ops = this.pendingOps.get(containerID);
            if (ops != null) {
                ListIterator<ContainerReplicaOp> iterator = ops.listIterator();
                while (iterator.hasNext()) {
                    ContainerReplicaOp op = (ContainerReplicaOp)iterator.next();
                    if (op.getOpType() != opType || !op.getTarget().equals((Object)target) || op.getReplicaIndex() != replicaIndex) continue;
                    found = true;
                    completedOps.add(op);
                    iterator.remove();
                    if (opType == ContainerReplicaOp.PendingOpType.ADD) {
                        this.containerSizeScheduled.computeIfPresent(target.getID(), (k, v) -> {
                            long newSize = v.getSize() - op.getContainerSize();
                            if (newSize <= 0L) {
                                return null;
                            }
                            return new SizeAndTime(newSize, v.getLastUpdatedTime());
                        });
                    }
                    this.decrementCounter(op.getOpType(), replicaIndex);
                }
                if (ops.isEmpty()) {
                    this.pendingOps.remove(containerID);
                }
            }
        }
        finally {
            this.unlock(lock);
        }
        if (found && notifySubsribers) {
            this.notifySubscribers(completedOps, containerID, false);
        }
        return found;
    }

    private void notifySubscribers(List<ContainerReplicaOp> ops, ContainerID containerID, boolean timedOut) {
        for (ContainerReplicaOp op : ops) {
            for (ContainerReplicaPendingOpsSubscriber subscriber : this.subscribers) {
                subscriber.opCompleted(op, containerID, timedOut);
            }
        }
    }

    public void registerSubscriber(ContainerReplicaPendingOpsSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    private Lock writeLock(ContainerID containerID) {
        return ((ReadWriteLock)this.stripedLock.get((Object)containerID)).writeLock();
    }

    private Lock readLock(ContainerID containerID) {
        return ((ReadWriteLock)this.stripedLock.get((Object)containerID)).readLock();
    }

    private void lock(Lock lock) {
        this.globalLock.readLock().lock();
        lock.lock();
    }

    private void unlock(Lock lock) {
        this.globalLock.readLock().unlock();
        lock.unlock();
    }

    public ConcurrentHashMap<DatanodeID, SizeAndTime> getContainerSizeScheduled() {
        return this.containerSizeScheduled;
    }

    public Clock getClock() {
        return this.clock;
    }

    private boolean isMetricsNotNull() {
        return this.replicationMetrics != null;
    }

    public void setReplicationMetrics(ReplicationManagerMetrics replicationMetrics) {
        this.replicationMetrics = replicationMetrics;
    }

    public long getPendingOpCount(ContainerReplicaOp.PendingOpType opType) {
        AtomicLong[] counters = this.pendingOpCount.get((Object)opType);
        long count = 0L;
        for (AtomicLong counter : counters) {
            count += counter.get();
        }
        return count;
    }

    public long getPendingOpCount(ContainerReplicaOp.PendingOpType opType, ReplicationType type) {
        int index = 0;
        if (type == ReplicationType.EC) {
            index = 1;
        }
        return this.pendingOpCount.get((Object)opType)[index].get();
    }

    private long incrementCounter(ContainerReplicaOp.PendingOpType type, int replicaIndex) {
        return this.pendingOpCount.get((Object)type)[this.counterIndex(replicaIndex)].incrementAndGet();
    }

    private long decrementCounter(ContainerReplicaOp.PendingOpType type, int replicaIndex) {
        return this.pendingOpCount.get((Object)type)[this.counterIndex(replicaIndex)].decrementAndGet();
    }

    private int counterIndex(int replicaIndex) {
        if (this.isEC(replicaIndex)) {
            return 1;
        }
        return 0;
    }

    private boolean isEC(int replicaIndex) {
        return replicaIndex > 0;
    }

    public static class SizeAndTime {
        private final long size;
        private final long lastUpdatedTime;

        public SizeAndTime(long size, long lastUpdatedTime) {
            this.size = size;
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public long getSize() {
            return this.size;
        }

        public long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public String toString() {
            return "Size: " + this.size + ", lastUpdatedTime: " + this.lastUpdatedTime;
        }
    }
}

