/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;

public abstract class AbstractContainerSafeModeRule
extends SafeModeExitRule<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> {
    private final ContainerManager containerManager;
    private final Map<ContainerID, Integer> containers = new ConcurrentHashMap<ContainerID, Integer>();
    private final double safeModeCutoff;
    private final AtomicInteger totalContainers = new AtomicInteger();
    private final AtomicInteger containersWithMinReplicas = new AtomicInteger();

    public AbstractContainerSafeModeRule(ConfigurationSource conf, SCMSafeModeManager safeModeManager, ContainerManager containerManager, EventQueue eventQueue) {
        super(safeModeManager, eventQueue);
        this.containerManager = containerManager;
        this.safeModeCutoff = AbstractContainerSafeModeRule.getSafeModeCutoff(conf);
        this.initializeRule();
    }

    protected abstract HddsProtos.ReplicationType getContainerType();

    protected abstract void handleReportedContainer(ContainerID var1, DatanodeID var2);

    protected long getNumberOfContainersWithMinReplica() {
        return this.containersWithMinReplicas.get();
    }

    protected final void incrementContainersWithMinReplicas() {
        this.containersWithMinReplicas.incrementAndGet();
    }

    protected void initializeRule() {
        this.containers.clear();
        this.containerManager.getContainers(this.getContainerType()).stream().filter(this::isClosed).filter(c -> c.getNumberOfKeys() > 0L).forEach(c -> this.containers.put(c.containerID(), c.getReplicationConfig().getMinimumNodes()));
        this.totalContainers.set(this.containers.size());
        long cutOff = (long)Math.ceil((double)this.getTotalNumberOfContainers() * this.getSafeModeCutoff());
        this.getSafeModeMetrics().setNumContainerReportedThreshold(this.getContainerType(), cutOff);
        SCMSafeModeManager.getLogger().info("Refreshed {} Containers threshold count to {}.", (Object)this.getContainerType(), (Object)cutOff);
    }

    protected Map<ContainerID, Integer> getContainers() {
        return this.containers;
    }

    protected int getTotalNumberOfContainers() {
        return this.totalContainers.get();
    }

    protected double getSafeModeCutoff() {
        return this.safeModeCutoff;
    }

    @Override
    protected TypedEvent<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> getEventType() {
        return SCMEvents.CONTAINER_REGISTRATION_REPORT;
    }

    @Override
    protected void process(SCMDatanodeProtocolServer.NodeRegistrationContainerReport report) {
        DatanodeID datanodeID = report.getDatanodeDetails().getID();
        ((StorageContainerDatanodeProtocolProtos.ContainerReportsProto)report.getReport()).getReportsList().stream().map(c -> ContainerID.valueOf((long)c.getContainerID())).forEach(cid -> this.handleReportedContainer((ContainerID)cid, datanodeID));
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. {} % containers [{}] have at least one reported replica", (Object)this.getContainerType(), (Object)String.format("%.2f", this.getCurrentContainerThreshold() * 100.0));
        }
    }

    @Override
    protected synchronized boolean validate() {
        if (this.validateBasedOnReportProcessing()) {
            return this.getCurrentContainerThreshold() >= this.getSafeModeCutoff();
        }
        List<ContainerInfo> containerInfos = this.containerManager.getContainers(this.getContainerType());
        return containerInfos.stream().filter(this::isClosed).map(ContainerInfo::containerID).noneMatch(this::isMissing);
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        long total = this.getTotalNumberOfContainers();
        return total == 0L ? 1.0 : (double)this.getNumberOfContainersWithMinReplica() / (double)total;
    }

    @Override
    public synchronized void refresh(boolean forceRefresh) {
        if (forceRefresh || !this.validate()) {
            this.initializeRule();
        }
    }

    @Override
    protected void cleanup() {
        this.getContainers().clear();
    }

    protected boolean isMissing(ContainerID id) {
        try {
            int minReplica = this.getMinReplica(id);
            return this.containerManager.getContainerReplicas(id).size() < minReplica;
        }
        catch (ContainerNotFoundException ex) {
            return false;
        }
    }

    protected boolean isClosed(ContainerInfo container) {
        HddsProtos.LifeCycleState state = container.getState();
        return state == HddsProtos.LifeCycleState.QUASI_CLOSED || state == HddsProtos.LifeCycleState.CLOSED;
    }

    protected int getMinReplica(ContainerID id) {
        return this.containers.getOrDefault(id, 0);
    }

    @Override
    public String getStatusText() {
        String status = String.format("%1.2f%% of [" + this.getContainerType() + "] Containers(%s / %s) with at least N reported replica (=%1.2f) >= safeModeCutoff (=%1.2f);", this.getCurrentContainerThreshold() * 100.0, this.getNumberOfContainersWithMinReplica(), this.getTotalNumberOfContainers(), this.getCurrentContainerThreshold(), this.getSafeModeCutoff());
        List sampleContainers = this.getContainers().keySet().stream().limit(5L).collect(Collectors.toList());
        if (!sampleContainers.isEmpty()) {
            String sampleECContainerText = "Sample  " + this.getContainerType() + " Containers not satisfying the criteria : " + sampleContainers + ";";
            status = status.concat("\n").concat(sampleECContainerText);
        }
        return status;
    }

    private static double getSafeModeCutoff(ConfigurationSource conf) {
        double cutoff = conf.getDouble("hdds.scm.safemode.threshold.pct", 0.99);
        Preconditions.checkArgument((cutoff >= 0.0 && cutoff <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.threshold.pct value should be >= 0.0 and <= 1.0");
        return cutoff;
    }
}

