/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationTarget;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.hdds.conf.TimeDurationUtil;

public enum ConfigType {
    AUTO{

        @Override
        Object parse(String value, Config config, Class<?> type, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    STRING{

        @Override
        String parse(String value, Config config, Class<?> type, String key) {
            return value;
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            target.set(key, String.valueOf(value));
        }
    }
    ,
    BOOLEAN{

        @Override
        Boolean parse(String value, Config config, Class<?> type, String key) {
            return Boolean.parseBoolean(value);
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            target.setBoolean(key, (Boolean)value);
        }
    }
    ,
    INT{

        @Override
        Integer parse(String value, Config config, Class<?> type, String key) {
            return Integer.parseInt(value);
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            target.setInt(key, (Integer)value);
        }
    }
    ,
    LONG{

        @Override
        Long parse(String value, Config config, Class<?> type, String key) {
            return Long.parseLong(value);
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            target.setLong(key, (Long)value);
        }
    }
    ,
    TIME{

        @Override
        Object parse(String value, Config config, Class<?> type, String key) {
            if (type == Duration.class) {
                return TimeDurationUtil.getDuration(key, value, config.timeUnit());
            }
            return TimeDurationUtil.getTimeDurationHelper(key, value, config.timeUnit());
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            if (value instanceof Duration) {
                Duration duration = (Duration)value;
                if (duration.getNano() % 1000000 > 0) {
                    target.setTimeDuration(key, duration.toNanos(), TimeUnit.NANOSECONDS);
                } else {
                    long millis = duration.toMillis();
                    target.setTimeDuration(key, millis, TimeUnit.MILLISECONDS);
                }
            } else {
                target.setTimeDuration(key, (Long)value, config.timeUnit());
            }
        }
    }
    ,
    SIZE{

        @Override
        Object parse(String value, Config config, Class<?> type, String key) {
            StorageSize measure = StorageSize.parse(value, config.sizeUnit());
            long val = Math.round(measure.getUnit().toBytes(measure.getValue()));
            if (type == Integer.TYPE) {
                return (int)val;
            }
            return val;
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            if (value instanceof Long) {
                target.setStorageSize(key, (Long)value, config.sizeUnit());
            } else if (value instanceof Integer) {
                target.setStorageSize(key, ((Integer)value).intValue(), config.sizeUnit());
            } else {
                throw new ConfigurationException("Unsupported type " + value.getClass() + " for " + key);
            }
        }
    }
    ,
    CLASS{

        @Override
        Class<?> parse(String value, Config config, Class<?> type, String key) throws ClassNotFoundException {
            return Class.forName(value);
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            if (!(value instanceof Class)) {
                throw new ConfigurationException("Unsupported type " + value.getClass() + " for " + key);
            }
            target.set(key, ((Class)value).getName());
        }
    }
    ,
    DOUBLE{

        @Override
        Double parse(String value, Config config, Class<?> type, String key) {
            return Double.parseDouble(value);
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            target.setDouble(key, (Double)value);
        }
    }
    ,
    FLOAT{

        @Override
        Float parse(String value, Config config, Class<?> type, String key) {
            return Float.valueOf(Float.parseFloat(value));
        }

        @Override
        void set(ConfigurationTarget target, String key, Object value, Config config) {
            target.setFloat(key, ((Float)value).floatValue());
        }
    };


    abstract Object parse(String var1, Config var2, Class<?> var3, String var4) throws Exception;

    abstract void set(ConfigurationTarget var1, String var2, Object var3, Config var4);
}

