/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

public class RDBMetrics {
    private static final String SOURCE_NAME = RDBMetrics.class.getSimpleName();
    private static RDBMetrics instance;
    @Metric
    private MutableCounterLong numDBKeyMayExistChecks;
    @Metric
    private MutableCounterLong numDBKeyMayExistMisses;
    @Metric
    private MutableCounterLong numDBKeyGets;
    @Metric
    private MutableCounterLong numDBKeyGetIfExistChecks;
    @Metric
    private MutableCounterLong numDBKeyGetIfExistMisses;
    @Metric
    private MutableCounterLong numDBKeyGetIfExistGets;
    @Metric
    private MutableCounterLong walUpdateDataSize;
    @Metric
    private MutableCounterLong walUpdateSequenceCount;

    public static synchronized RDBMetrics create() {
        if (instance != null) {
            return instance;
        }
        MetricsSystem ms = DefaultMetricsSystem.instance();
        instance = (RDBMetrics)ms.register(SOURCE_NAME, "Rocks DB Metrics", (Object)new RDBMetrics());
        return instance;
    }

    public long getNumDBKeyGets() {
        return this.numDBKeyGets.value();
    }

    public void incNumDBKeyGets() {
        this.numDBKeyGets.incr();
    }

    public long getNumDBKeyGetIfExistGets() {
        return this.numDBKeyGetIfExistGets.value();
    }

    public void incNumDBKeyGetIfExistGets() {
        this.numDBKeyGetIfExistGets.incr();
    }

    public long getNumDBKeyGetIfExistChecks() {
        return this.numDBKeyGetIfExistChecks.value();
    }

    public void incNumDBKeyGetIfExistChecks() {
        this.numDBKeyGetIfExistChecks.incr();
    }

    public long getNumDBKeyGetIfExistMisses() {
        return this.numDBKeyGetIfExistMisses.value();
    }

    public void incNumDBKeyGetIfExistMisses() {
        this.numDBKeyGetIfExistMisses.incr();
    }

    public void incNumDBKeyMayExistChecks() {
        this.numDBKeyMayExistChecks.incr();
    }

    public void incNumDBKeyMayExistMisses() {
        this.numDBKeyMayExistMisses.incr();
    }

    @VisibleForTesting
    public long getNumDBKeyMayExistChecks() {
        return this.numDBKeyMayExistChecks.value();
    }

    @VisibleForTesting
    public long getNumDBKeyMayExistMisses() {
        return this.numDBKeyMayExistMisses.value();
    }

    public void incWalUpdateDataSize(long size) {
        this.walUpdateDataSize.incr(size);
    }

    public long getWalUpdateDataSize() {
        return this.walUpdateDataSize.value();
    }

    public void incWalUpdateSequenceCount(long count) {
        this.walUpdateSequenceCount.incr(count);
    }

    public long getWalUpdateSequenceCount() {
        return this.walUpdateSequenceCount.value();
    }

    public static synchronized void unRegister() {
        instance = null;
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

