/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public class VectorizedOrcInputFormat
extends FileInputFormat<NullWritable, VectorizedRowBatch>
implements InputFormatChecker,
VectorizedInputFormatInterface {
    public VectorizedOrcInputFormat() {
        this.setMinSplitSize(16384L);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        OrcSplit orcSplit;
        FileSplit fSplit = (FileSplit)inputSplit;
        reporter.setStatus(fSplit.toString());
        Path path = fSplit.getPath();
        OrcFile.ReaderOptions opts = OrcFile.readerOptions((Configuration)conf);
        if (fSplit instanceof OrcSplit && (orcSplit = (OrcSplit)fSplit).hasFooter()) {
            opts.fileMetaInfo(orcSplit.getFileMetaInfo());
        }
        Reader reader = OrcFile.createReader(path, opts);
        return new VectorizedOrcRecordReader(reader, (Configuration)conf, fSplit);
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            try {
                OrcFile.createReader(file.getPath(), OrcFile.readerOptions((Configuration)conf).filesystem(fs));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    static class VectorizedOrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private float progress = 0.0f;
        private VectorizedRowBatchCtx rbCtx;
        private boolean addPartitionCols = true;

        VectorizedOrcRecordReader(Reader file, Configuration conf, FileSplit fileSplit) throws IOException {
            List<OrcProto.Type> types = file.getTypes();
            Reader.Options options = new Reader.Options();
            this.offset = fileSplit.getStart();
            this.length = fileSplit.getLength();
            options.range(this.offset, this.length);
            options.include(OrcInputFormat.genIncludedColumns(types, conf, true));
            OrcInputFormat.setSearchArgument(options, types, conf, true);
            this.reader = file.rowsOptions(options);
            try {
                this.rbCtx = new VectorizedRowBatchCtx();
                this.rbCtx.init(conf, fileSplit);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
            if (!this.reader.hasNext()) {
                return false;
            }
            try {
                if (this.addPartitionCols) {
                    this.rbCtx.addPartitionColsToBatch(value);
                    this.addPartitionCols = false;
                }
                this.reader.nextBatch(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.progress = this.reader.getProgress();
            return true;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public VectorizedRowBatch createValue() {
            try {
                return this.rbCtx.createVectorizedRowBatch();
            }
            catch (HiveException e) {
                throw new RuntimeException("Error creating a batch", e);
            }
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }
    }
}

