/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class DeleteScanIterCommand
extends Shell.Command {
    private Option nameOpt;
    private Option allOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        if (cl.hasOption(this.allOpt.getOpt())) {
            List<IteratorSetting> tableScanIterators = shellState.scanIteratorOptions.remove(tableName);
            if (tableScanIterators == null) {
                Shell.log.info((Object)("No scan iterators set on table " + tableName));
            } else {
                Shell.log.info((Object)("Removed the following scan iterators from table " + tableName + ":" + tableScanIterators));
            }
        } else if (cl.hasOption(this.nameOpt.getOpt())) {
            String name = cl.getOptionValue(this.nameOpt.getOpt());
            List<IteratorSetting> tableScanIterators = shellState.scanIteratorOptions.get(tableName);
            if (tableScanIterators != null) {
                boolean found = false;
                Iterator<IteratorSetting> iter = tableScanIterators.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().getName().equals(name)) continue;
                    iter.remove();
                    found = true;
                    break;
                }
                if (!found) {
                    Shell.log.info((Object)("No iterator named " + name + " found for table " + tableName));
                } else {
                    Shell.log.info((Object)("Removed scan iterator " + name + " from table " + tableName + " (" + shellState.scanIteratorOptions.get(tableName).size() + " left)"));
                    if (shellState.scanIteratorOptions.get(tableName).size() == 0) {
                        shellState.scanIteratorOptions.remove(tableName);
                    }
                }
            } else {
                Shell.log.info((Object)("No iterator named " + name + " found for table " + tableName));
            }
        }
        return 0;
    }

    @Override
    public String description() {
        return "deletes a table-specific scan iterator so it is no longer used during this shell session";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup nameGroup = new OptionGroup();
        this.nameOpt = new Option("n", "name", true, "iterator to delete");
        this.nameOpt.setArgName("itername");
        this.allOpt = new Option("a", "all", false, "delete all scan iterators");
        this.allOpt.setArgName("all");
        nameGroup.addOption(this.nameOpt);
        nameGroup.addOption(this.allOpt);
        nameGroup.setRequired(true);
        o.addOptionGroup(nameGroup);
        o.addOption(OptUtil.tableOpt("table to delete scan iterators from"));
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

