/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.net.NetUtils;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestIPC
extends AbstractTestIPC {
    private static final Log LOG = LogFactory.getLog(TestIPC.class);

    protected RpcClientImpl createRpcClientNoCodec(Configuration conf) {
        return new RpcClientImpl(conf, "default-cluster"){

            Codec getCodec() {
                return null;
            }
        };
    }

    protected RpcClientImpl createRpcClient(Configuration conf) {
        return new RpcClientImpl(conf, "default-cluster");
    }

    protected RpcClientImpl createRpcClientRTEDuringConnectionSetup(Configuration conf) throws IOException {
        SocketFactory spyFactory = (SocketFactory)Mockito.spy((Object)NetUtils.getDefaultSocketFactory((Configuration)conf));
        ((SocketFactory)Mockito.doAnswer((Answer)new Answer<Socket>(){

            public Socket answer(InvocationOnMock invocation) throws Throwable {
                Socket s = (Socket)Mockito.spy((Object)((Socket)invocation.callRealMethod()));
                ((Socket)Mockito.doThrow((Throwable)new RuntimeException("Injected fault")).when((Object)s)).setSoTimeout(Matchers.anyInt());
                return s;
            }
        }).when((Object)spyFactory)).createSocket();
        return new RpcClientImpl(conf, "default-cluster", spyFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SecurityException, NoSuchMethodException, InterruptedException {
        if (args.length != 2) {
            System.out.println("Usage: TestIPC <CYCLES> <CELLS_PER_CYCLE>");
            return;
        }
        int cycles = Integer.parseInt(args[0]);
        int cellcount = Integer.parseInt(args[1]);
        Configuration conf = HBaseConfiguration.create();
        AbstractTestIPC.TestRpcServer rpcServer = new AbstractTestIPC.TestRpcServer();
        Descriptors.MethodDescriptor md = SERVICE.getDescriptorForType().findMethodByName("echo");
        TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
        RpcClientImpl client = new RpcClientImpl(conf, "default-cluster");
        KeyValue kv = BIG_CELL;
        Put p = new Put(CellUtil.cloneRow((Cell)kv));
        for (int i = 0; i < cellcount; ++i) {
            p.add((Cell)kv);
        }
        RowMutations rm = new RowMutations(CellUtil.cloneRow((Cell)kv));
        rm.add(p);
        try {
            rpcServer.start();
            long startTime = System.currentTimeMillis();
            User user = User.getCurrent();
            InetSocketAddress address = rpcServer.getListenerAddress();
            if (address == null) {
                throw new IOException("Listener channel is closed");
            }
            for (int i = 0; i < cycles; ++i) {
                ArrayList cells = new ArrayList();
                ClientProtos.RegionAction.Builder builder = RequestConverter.buildNoDataRegionAction((byte[])HConstants.EMPTY_BYTE_ARRAY, (RowMutations)rm, cells, (ClientProtos.RegionAction.Builder)ClientProtos.RegionAction.newBuilder(), (ClientProtos.Action.Builder)ClientProtos.Action.newBuilder(), (ClientProtos.MutationProto.Builder)ClientProtos.MutationProto.newBuilder());
                builder.setRegion(HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).setValue(ByteString.copyFrom((byte[])HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes())));
                if (i % 100000 == 0) {
                    LOG.info((Object)("" + i));
                }
                PayloadCarryingRpcController pcrc = new PayloadCarryingRpcController(CellUtil.createCellScanner(cells));
                client.call(pcrc, md, (Message)builder.build(), (Message)param, user, address, new MetricsConnection.CallStats());
            }
            LOG.info((Object)("Cycled " + cycles + " time(s) with " + cellcount + " cell(s) in " + (System.currentTimeMillis() - startTime) + "ms"));
        }
        finally {
            client.close();
            rpcServer.stop();
        }
    }
}

